/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.threadpool.ThreadPool;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class ThreadedActionListener<Response>
implements ActionListener<Response> {
    private final Logger logger;
    private final ThreadPool threadPool;
    private final String executor;
    private final ActionListener<Response> listener;
    private final boolean forceExecution;

    public ThreadedActionListener(Logger logger, ThreadPool threadPool, String executor, ActionListener<Response> listener, boolean forceExecution) {
        this.logger = logger;
        this.threadPool = threadPool;
        this.executor = executor;
        this.listener = listener;
        this.forceExecution = forceExecution;
    }

    public void onResponse(final Response response) {
        this.threadPool.executor(this.executor).execute((Runnable)new ActionRunnable<Response>(this.listener){

            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            public void doRun() {
                this.listener.onResponse(response);
            }
        });
    }

    public void onFailure(final Exception e) {
        this.threadPool.executor(this.executor).execute((Runnable)new AbstractRunnable(){

            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            public void doRun() throws Exception {
                ThreadedActionListener.this.listener.onFailure(e);
            }

            public void onFailure(Exception e2) {
                ThreadedActionListener.this.logger.warn(() -> new ParameterizedMessage("failed to execute failure callback on [{}]", ThreadedActionListener.this.listener), (Throwable)e2);
            }
        });
    }
}

