/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import io.skylite.core.action.search.TransportSearchAction;
import io.skylite.core.client.OriginSettingClient;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.tasks.CancellableTask;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.threadpool.Scheduler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TimeoutTaskCancellationUtility {
    private static final Logger logger = LogManager.getLogger(TimeoutTaskCancellationUtility.class);

    public static <Response> ActionListener<Response> wrapWithCancellationListener(NodeClient client, CancellableTask taskToCancel, ClusterSettings clusterSettings, ActionListener<Response> listener) {
        TimeValue globalTimeout = clusterSettings.get(TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING);
        TimeValue timeoutInterval = taskToCancel.getCancellationTimeout() == null ? globalTimeout : taskToCancel.getCancellationTimeout();
        ActionListener<Response> listenerToReturn = listener;
        if (timeoutInterval.equals((Object)TimeValue.NO_TIMEOUT)) {
            return listenerToReturn;
        }
        try {
            TimeoutRunnableListener<Response> wrappedListener = new TimeoutRunnableListener<Response>(timeoutInterval, listener, () -> {
                CancelTasksRequest cancelTasksRequest = new CancelTasksRequest();
                cancelTasksRequest.setTaskId(new TaskId(client.getLocalNodeId(), taskToCancel.getId()));
                cancelTasksRequest.setReason("Cancellation timeout of " + String.valueOf(timeoutInterval) + " is expired");
                new OriginSettingClient(client, "tasks").admin().cluster().cancelTasks(cancelTasksRequest, ActionListenerHelper.wrap(r -> logger.debug("Scheduled cancel task with timeout: {} for original task: {} is successfully completed", (Object)timeoutInterval, (Object)cancelTasksRequest.getTaskId()), e -> logger.error((Message)new ParameterizedMessage("Scheduled cancel task with timeout: {} for original task: {} is failed", (Object)timeoutInterval, (Object)cancelTasksRequest.getTaskId()), (Throwable)e)));
            });
            wrappedListener.cancellable = client.threadPool().schedule(wrappedListener, timeoutInterval, "generic");
            listenerToReturn = wrappedListener;
        }
        catch (Exception ex) {
            logger.warn("Failed to schedule the cancellation task for original task: {}, will continue without it", (Object)taskToCancel.getId());
        }
        return listenerToReturn;
    }

    private static class TimeoutRunnableListener<Response>
    implements ActionListener<Response>,
    Runnable {
        private static final Logger logger = LogManager.getLogger(TimeoutRunnableListener.class);
        private final TimeValue timeout;
        private final ActionListener<Response> originalListener;
        private final Runnable timeoutRunnable;
        private final AtomicBoolean executeRunnable = new AtomicBoolean(true);
        private volatile Scheduler.ScheduledCancellable cancellable;
        private final long creationTime;

        TimeoutRunnableListener(TimeValue timeout, ActionListener<Response> listener, Runnable runAfterTimeout) {
            this.timeout = timeout;
            this.originalListener = listener;
            this.timeoutRunnable = runAfterTimeout;
            this.creationTime = System.nanoTime();
        }

        public void onResponse(Response response) {
            this.checkAndCancel();
            this.originalListener.onResponse(response);
        }

        public void onFailure(Exception e) {
            this.checkAndCancel();
            this.originalListener.onFailure(e);
        }

        @Override
        public void run() {
            try {
                if (this.executeRunnable.compareAndSet(true, false)) {
                    this.timeoutRunnable.run();
                }
            }
            catch (Exception ex) {
                logger.error((Message)new ParameterizedMessage("Ignoring the failure to run the provided runnable after timeout of {} with exception", (Object)this.timeout), (Throwable)ex);
            }
        }

        private void checkAndCancel() {
            if (this.executeRunnable.compareAndSet(true, false)) {
                logger.debug("Aborting the scheduled cancel task after {}", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.creationTime));
                this.cancellable.cancel();
            }
        }
    }
}

