/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.broadcast;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class BroadcastRequest<Request extends BroadcastRequest<Request>>
extends ActionRequest
implements IndicesRequest.Replaceable {
    protected String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();
    private final TimeValue DEFAULT_TIMEOUT_SECONDS = TimeValue.timeValueSeconds((long)30L);
    private TimeValue timeout;

    public BroadcastRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    protected BroadcastRequest(String ... indices) {
        this.indices = indices;
    }

    protected BroadcastRequest(String[] indices, IndicesOptions indicesOptions) {
        this.indices = indices;
        this.indicesOptions = indicesOptions;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public final Request indices(String ... indices) {
        this.indices = indices;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue((String)timeout, (TimeValue)this.DEFAULT_TIMEOUT_SECONDS, (String)(this.getClass().getSimpleName() + ".timeout"));
        return (Request)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final Request indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (Request)this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }
}

