/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.replication;

import io.skylite.common.Nullable;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import java.io.IOException;

public abstract class ReplicatedWriteRequest<R extends ReplicatedWriteRequest<R>>
extends ReplicationRequest<R>
implements WriteRequest<R> {
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.NONE;

    public ReplicatedWriteRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
    }

    public ReplicatedWriteRequest(StreamInput in) throws IOException {
        super(in);
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
    }

    public ReplicatedWriteRequest(@Nullable ShardId shardId) {
        super(shardId);
    }

    @Override
    public R setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return (R)this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.refreshPolicy.writeTo(out);
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeThin(out);
        this.refreshPolicy.writeTo(out);
    }
}

