/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.replication;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.support.replication.ReplicationMode;
import io.skylite.core.action.support.replication.ReplicationOperation;
import io.skylite.core.action.support.replication.ReplicationProxy;
import io.skylite.core.action.support.replication.ReplicationProxyRequest;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ReplicationModeAwareProxy<ReplicaRequest extends ReplicationRequest<ReplicaRequest>>
extends ReplicationProxy<ReplicaRequest> {
    private final ReplicationMode replicationModeOverride;
    private final ReplicationOperation.Replicas<ReplicaRequest> primaryTermValidationProxy;
    private final DiscoveryNodes discoveryNodes;
    private final boolean isRemoteEnabled;

    public ReplicationModeAwareProxy(ReplicationMode replicationModeOverride, DiscoveryNodes discoveryNodes, ReplicationOperation.Replicas<ReplicaRequest> replicasProxy, ReplicationOperation.Replicas<ReplicaRequest> primaryTermValidationProxy, boolean remoteIndexSettingsEnabled) {
        super(replicasProxy);
        this.replicationModeOverride = Objects.requireNonNull(replicationModeOverride);
        this.primaryTermValidationProxy = Objects.requireNonNull(primaryTermValidationProxy);
        this.discoveryNodes = discoveryNodes;
        this.isRemoteEnabled = remoteIndexSettingsEnabled;
    }

    @Override
    protected void performOnReplicaProxy(ReplicationProxyRequest<ReplicaRequest> proxyRequest, ReplicationMode replicationMode, BiConsumer<Consumer<ActionListener<ReplicationOperation.ReplicaResponse>>, ReplicationProxyRequest<ReplicaRequest>> performOnReplicaConsumer) {
        assert (replicationMode == ReplicationMode.FULL_REPLICATION || replicationMode == ReplicationMode.PRIMARY_TERM_VALIDATION);
        Consumer<ActionListener<ReplicationOperation.ReplicaResponse>> replicasProxyConsumer = replicationMode == ReplicationMode.FULL_REPLICATION ? this.getReplicasProxyConsumer(this.fullReplicationProxy, proxyRequest) : this.getReplicasProxyConsumer(this.primaryTermValidationProxy, proxyRequest);
        performOnReplicaConsumer.accept(replicasProxyConsumer, proxyRequest);
    }

    @Override
    ReplicationMode determineReplicationMode(ShardRouting shardRouting, ShardRouting primaryRouting) {
        DiscoveryNode targetNode;
        if (shardRouting.isSameAllocation(primaryRouting)) {
            return ReplicationMode.NO_REPLICATION;
        }
        if (primaryRouting.relocating() && shardRouting.isSameAllocation(primaryRouting.getTargetRelocatingShard())) {
            return ReplicationMode.FULL_REPLICATION;
        }
        if (!this.isRemoteEnabled && (targetNode = this.discoveryNodes.get(shardRouting.currentNodeId())) != null && !targetNode.isRemoteStoreNode()) {
            return ReplicationMode.FULL_REPLICATION;
        }
        return this.replicationModeOverride;
    }
}

