/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.single.instance;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.ShardId;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public abstract class InstanceShardOperationRequest<Request extends InstanceShardOperationRequest<Request>>
extends ActionRequest
implements IndicesRequest {
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected String index;
    protected ShardId shardId = null;
    private String concreteIndex;

    protected InstanceShardOperationRequest() {
    }

    protected InstanceShardOperationRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(in);
        if (shardId == null) {
            this.index = in.readString();
            this.shardId = in.readOptionalWriteable(ShardId::new);
        } else {
            this.shardId = shardId;
            this.index = in.readBoolean() ? in.readString() : shardId.getIndexName();
        }
        this.timeout = in.readTimeValue();
        this.concreteIndex = in.readOptionalString();
    }

    public InstanceShardOperationRequest(String index) {
        this.index = index;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
        }
        return validationException;
    }

    public String index() {
        return this.index;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public final Request index(String index) {
        this.index = index;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public void setShardId(ShardId shardId) {
        this.shardId = shardId;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
    }

    public String concreteIndex() {
        return this.concreteIndex;
    }

    public void concreteIndex(String concreteIndex) {
        this.concreteIndex = concreteIndex;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeOptionalWriteable(this.shardId);
        out.writeTimeValue(this.timeout);
        out.writeOptionalString(this.concreteIndex);
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.shardId != null && this.index.equals(this.shardId.getIndexName())) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.index);
        }
        out.writeTimeValue(this.timeout);
        out.writeOptionalString(this.concreteIndex);
    }
}

