/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.support.tasks;

import io.skylite.SkyliteException;
import io.skylite.common.ExceptionsHelper;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.TaskOperationFailure;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BaseTasksResponse
extends ActionResponse {
    protected static final String TASK_FAILURES = "task_failures";
    protected static final String NODE_FAILURES = "node_failures";
    private List<TaskOperationFailure> taskFailures;
    private List<SkyliteException> nodeFailures;

    public BaseTasksResponse(List<TaskOperationFailure> taskFailures, List<? extends SkyliteException> nodeFailures) {
        this.taskFailures = taskFailures == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<TaskOperationFailure>(taskFailures));
        this.nodeFailures = nodeFailures == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<SkyliteException>(nodeFailures));
    }

    public BaseTasksResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ArrayList<TaskOperationFailure> taskFailures = new ArrayList<TaskOperationFailure>(size);
        for (int i = 0; i < size; ++i) {
            taskFailures.add(new TaskOperationFailure(in));
        }
        size = in.readVInt();
        this.taskFailures = Collections.unmodifiableList(taskFailures);
        ArrayList<FailedNodeException> nodeFailures = new ArrayList<FailedNodeException>(size);
        for (int i = 0; i < size; ++i) {
            nodeFailures.add(new FailedNodeException(in));
        }
        this.nodeFailures = Collections.unmodifiableList(nodeFailures);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.taskFailures.size());
        for (TaskOperationFailure taskOperationFailure : this.taskFailures) {
            taskOperationFailure.writeTo(out);
        }
        out.writeVInt(this.nodeFailures.size());
        for (SkyliteException skyliteException : this.nodeFailures) {
            skyliteException.writeTo(out);
        }
    }

    public List<TaskOperationFailure> getTaskFailures() {
        return this.taskFailures;
    }

    public List<SkyliteException> getNodeFailures() {
        return this.nodeFailures;
    }

    public void rethrowFailures(String operationName) {
        ExceptionsHelper.rethrowAndSuppress(Stream.concat(this.getNodeFailures().stream(), this.getTaskFailures().stream().map(f -> new SkyliteException("{} of [{}] failed", (Throwable)f.getCause(), operationName, new TaskId(f.getNodeId(), f.getTaskId())))).collect(Collectors.toList()));
    }

    protected void toXContentCommon(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.getTaskFailures() != null && this.getTaskFailures().size() > 0) {
            builder.startArray(TASK_FAILURES);
            for (TaskOperationFailure taskOperationFailure : this.getTaskFailures()) {
                builder.startObject();
                builder.value((Object)taskOperationFailure);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.getNodeFailures() != null && this.getNodeFailures().size() > 0) {
            builder.startArray(NODE_FAILURES);
            for (SkyliteException skyliteException : this.getNodeFailures()) {
                builder.startObject();
                skyliteException.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseTasksResponse response = (BaseTasksResponse)o;
        return this.taskFailures.equals(response.taskFailures) && this.nodeFailures.equals(response.nodeFailures);
    }

    public int hashCode() {
        return Objects.hash(this.taskFailures, this.nodeFailures);
    }
}

