/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.termvectors;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.termvectors.MultiTermVectorsResponse;
import io.skylite.core.action.termvectors.TermVectorsResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiTermVectorsShardResponse
extends ActionResponse {
    final List<Integer> locations;
    final List<TermVectorsResponse> responses;
    final List<MultiTermVectorsResponse.Failure> failures;

    public MultiTermVectorsShardResponse() {
        this.locations = new ArrayList<Integer>();
        this.responses = new ArrayList<TermVectorsResponse>();
        this.failures = new ArrayList<MultiTermVectorsResponse.Failure>();
    }

    public MultiTermVectorsShardResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.locations = new ArrayList<Integer>(size);
        this.responses = new ArrayList<TermVectorsResponse>(size);
        this.failures = new ArrayList<MultiTermVectorsResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.responses.add(new TermVectorsResponse(in));
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(new MultiTermVectorsResponse.Failure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    public List<Integer> getLocations() {
        return this.locations;
    }

    public List<TermVectorsResponse> getResponses() {
        return this.responses;
    }

    public List<MultiTermVectorsResponse.Failure> getFailures() {
        return this.failures;
    }

    public void add(int location, TermVectorsResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiTermVectorsResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }
}

