/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.AggregationUsageService;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AggregationRegistry {
    public static final RegistryKey UNREGISTERED_KEY = new RegistryKey<RegistryKey>("unregistered", RegistryKey.class);
    private final AggregationUsageService usageService;
    private final Map<RegistryKey<?>, Map<ValuesSourceType, ?>> aggregatorRegistry;

    private static Map<RegistryKey<?>, Map<ValuesSourceType, ?>> copyMap(Map<RegistryKey<?>, List<Map.Entry<ValuesSourceType, ?>>> mutableMap) {
        HashMap tmp = new HashMap();
        mutableMap.forEach((key, value) -> tmp.put(key, value.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        return Collections.unmodifiableMap(tmp);
    }

    public AggregationRegistry(Map<RegistryKey<?>, List<Map.Entry<ValuesSourceType, ?>>> aggregatorRegistry, AggregationUsageService usageService) {
        this.usageService = usageService;
        this.aggregatorRegistry = AggregationRegistry.copyMap(aggregatorRegistry);
    }

    public boolean isRegistered(RegistryKey<?> registryKey) {
        return this.aggregatorRegistry.containsKey(registryKey);
    }

    public <T> T getAggregator(RegistryKey<T> registryKey, ValuesSourceConfig valuesSourceConfig) {
        if (registryKey != null && this.aggregatorRegistry.containsKey(registryKey)) {
            Object supplier = this.aggregatorRegistry.get(registryKey).get(valuesSourceConfig.valueSourceType());
            if (supplier == null) {
                throw new IllegalArgumentException(valuesSourceConfig.getDescription() + " is not supported for aggregation [" + registryKey.getName() + "]");
            }
            return (T)supplier;
        }
        throw new AggregationExecutionException("Unregistered Aggregation [" + registryKey.getName() + "]");
    }

    public AggregationUsageService getUsageService() {
        return this.usageService;
    }

    public static final class RegistryKey<T> {
        private final String name;
        private final Class<T> supplierType;

        public RegistryKey(String name, Class<T> supplierType) {
            this.name = Objects.requireNonNull(name);
            this.supplierType = Objects.requireNonNull(supplierType);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegistryKey that = (RegistryKey)o;
            return this.name.equals(that.name) && this.supplierType.equals(that.supplierType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.supplierType);
        }
    }

    public static class Builder {
        private final AggregationUsageService.Builder usageServiceBuilder;
        private Map<RegistryKey<?>, List<Map.Entry<ValuesSourceType, ?>>> aggregatorRegistry = new HashMap();

        public Builder() {
            this.usageServiceBuilder = new AggregationUsageService.Builder();
        }

        public <T> void register(RegistryKey<T> registryKey, ValuesSourceType valuesSourceType, T aggregatorSupplier, boolean registerUsage) {
            if (!this.aggregatorRegistry.containsKey(registryKey)) {
                this.aggregatorRegistry.put(registryKey, new ArrayList());
            }
            this.aggregatorRegistry.get(registryKey).add(new AbstractMap.SimpleEntry<ValuesSourceType, T>(valuesSourceType, aggregatorSupplier));
            if (registerUsage) {
                this.registerUsage(registryKey.getName(), valuesSourceType);
            }
        }

        public <T> void register(RegistryKey<T> registryKey, List<ValuesSourceType> valuesSourceTypes, T aggregatorSupplier, boolean registerUsage) {
            for (ValuesSourceType valuesSourceType : valuesSourceTypes) {
                this.register(registryKey, valuesSourceType, aggregatorSupplier, registerUsage);
            }
        }

        public void registerUsage(String aggregationName, ValuesSourceType valuesSourceType) {
            this.usageServiceBuilder.registerAggregationUsage(aggregationName, valuesSourceType.typeName());
        }

        public void registerUsage(String aggregationName) {
            this.usageServiceBuilder.registerAggregationUsage(aggregationName);
        }

        public AggregationRegistry build() {
            return new AggregationRegistry(this.aggregatorRegistry, this.usageServiceBuilder.build());
        }
    }
}

