/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;

public abstract class AggregatorFactory {
    protected final String name;
    protected final AggregatorFactory parent;
    protected final AggregatorFactories factories;
    protected final Map<String, Object> metadata;
    protected final AggregationContext context;

    public AggregatorFactory(String name, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        this.name = name;
        this.context = context;
        this.parent = parent;
        this.factories = subFactoriesBuilder.build(context, this);
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public void doValidate() {
    }

    protected abstract Aggregator createInternal(SearchExecutionContext var1, Aggregator var2, CardinalityUpperBound var3, Map<String, Object> var4) throws IOException;

    public final Aggregator create(SearchExecutionContext context, Aggregator parent, CardinalityUpperBound cardinality) throws IOException {
        return this.createInternal(context, parent, cardinality, this.metadata);
    }

    public AggregatorFactory getParent() {
        return this.parent;
    }

    public String getStatsSubtype() {
        return "other";
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return false;
    }

    public boolean evaluateChildFactories() {
        return this.factories.allFactoriesSupportConcurrentSearch();
    }

    public boolean isGlobalAggregation() {
        return false;
    }
}

