/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.BucketCollector;
import io.skylite.core.aggregations.MultiBucketCollector;
import io.skylite.core.lucene.MinimumScoreCollector;
import io.skylite.core.search.profile.query.InternalProfileCollector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;

public class BucketCollectorProcessor {
    public void processPostCollection(Collector collectorTree) throws IOException {
        LinkedList<Collector> collectors = new LinkedList<Collector>();
        collectors.offer(collectorTree);
        while (!collectors.isEmpty()) {
            Collector currentCollector = (Collector)collectors.poll();
            if (currentCollector instanceof InternalProfileCollector) {
                collectors.offer(((InternalProfileCollector)currentCollector).getCollector());
                continue;
            }
            if (currentCollector instanceof MinimumScoreCollector) {
                collectors.offer(((MinimumScoreCollector)currentCollector).getCollector());
                continue;
            }
            if (currentCollector instanceof MultiCollector) {
                for (Collector innerCollector : ((MultiCollector)currentCollector).getCollectors()) {
                    collectors.offer(innerCollector);
                }
                continue;
            }
            if (!(currentCollector instanceof BucketCollector)) continue;
            ((BucketCollector)currentCollector).postCollection();
        }
    }

    public List<Aggregator> toAggregators(Collection<Collector> collectors) {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        LinkedList<Collector> allCollectors = new LinkedList<Collector>(collectors);
        while (!allCollectors.isEmpty()) {
            Collector currentCollector = (Collector)allCollectors.pop();
            if (currentCollector instanceof Aggregator) {
                aggregators.add((Aggregator)currentCollector);
                continue;
            }
            if (currentCollector instanceof InternalProfileCollector) {
                if (((InternalProfileCollector)currentCollector).getCollector() instanceof Aggregator) {
                    aggregators.add((Aggregator)((InternalProfileCollector)currentCollector).getCollector());
                    continue;
                }
                if (!(((InternalProfileCollector)currentCollector).getCollector() instanceof MultiBucketCollector)) continue;
                allCollectors.addAll(Arrays.asList(((MultiBucketCollector)((InternalProfileCollector)currentCollector).getCollector()).getCollectors()));
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            allCollectors.addAll(Arrays.asList(((MultiBucketCollector)currentCollector).getCollectors()));
        }
        return aggregators;
    }
}

