/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.core.aggregations.AggregationCollectorManager;
import io.skylite.core.aggregations.AggregationInitializationException;
import io.skylite.core.aggregations.AggregationProcessor;
import io.skylite.core.aggregations.BucketCollectorProcessor;
import io.skylite.core.aggregations.GlobalAggCollectorManager;
import io.skylite.core.aggregations.NonGlobalAggCollectorManager;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.profile.query.InternalProfileCollectorManager;
import io.skylite.core.search.query.QueryPhaseExecutionException;
import io.skylite.core.search.query.ReduceableSearchResult;
import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.search.Query;

public class ConcurrentAggregationProcessor
implements AggregationProcessor {
    private final BucketCollectorProcessor bucketCollectorProcessor = new BucketCollectorProcessor();

    @Override
    public void preProcess(SearchExecutionContext context) {
        try {
            if (context.aggregations() != null) {
                context.setBucketCollectorProcessor(this.bucketCollectorProcessor);
                if (context.aggregations().factories().hasNonGlobalAggregator()) {
                    context.queryCollectorManagers().put(NonGlobalAggCollectorManager.class, new NonGlobalAggCollectorManager(context));
                }
                if (context.aggregations().factories().hasGlobalAggregator()) {
                    context.queryCollectorManagers().put(GlobalAggCollectorManager.class, new GlobalAggCollectorManager(context));
                }
            }
        }
        catch (IOException ex) {
            throw new AggregationInitializationException("Could not initialize aggregators", ex);
        }
    }

    @Override
    public void postProcess(SearchExecutionContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        InternalProfileCollectorManager globalCollectorManager = context.queryCollectorManagers().get(GlobalAggCollectorManager.class);
        try {
            if (globalCollectorManager != null) {
                Query query = context.buildFilteredQuery(Queries.newMatchAllQuery());
                if (context.getProfilers() != null) {
                    globalCollectorManager = new InternalProfileCollectorManager(globalCollectorManager, ((AggregationCollectorManager)((Object)globalCollectorManager)).getCollectorReason(), Collections.emptyList());
                    context.getProfilers().addQueryProfiler().setCollector(globalCollectorManager);
                }
                ReduceableSearchResult result = (ReduceableSearchResult)context.searcher().search(query, globalCollectorManager);
                result.reduce(context.queryResult());
            }
        }
        catch (Exception e) {
            throw new QueryPhaseExecutionException(context.shardTarget(), "Failed to execute global aggregators", e);
        }
        context.aggregations(null);
        context.queryCollectorManagers().remove(NonGlobalAggCollectorManager.class);
        context.queryCollectorManagers().remove(GlobalAggCollectorManager.class);
    }
}

