/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.BaseAggregationBuilder;
import io.skylite.core.aggregations.pipeline.PipelineAggregator;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public abstract class PipelineAggregationBuilder
implements NamedWriteable,
BaseAggregationBuilder,
ToXContentFragment,
Rewriteable<PipelineAggregationBuilder> {
    protected final String name;
    protected final String[] bucketsPaths;

    protected PipelineAggregationBuilder(String name, String[] bucketsPaths) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        if (bucketsPaths == null) {
            throw new IllegalArgumentException("[bucketsPaths] must not be null: [" + name + "]");
        }
        this.name = name;
        this.bucketsPaths = bucketsPaths;
    }

    public String getName() {
        return this.name;
    }

    public final String[] getBucketsPaths() {
        return this.bucketsPaths;
    }

    protected abstract void validate(ValidationContext var1);

    protected abstract PipelineAggregator create();

    @Override
    public abstract PipelineAggregationBuilder setMetadata(Map<String, Object> var1);

    @Override
    public PipelineAggregationBuilder subAggregations(AggregatorFactories.Builder subFactories) {
        throw new IllegalArgumentException("Aggregation [" + this.name + "] cannot define sub-aggregations");
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    @Override
    public PipelineAggregationBuilder rewrite(QueryRewriteContext context) throws IOException {
        return this;
    }

    public static abstract class ValidationContext {
        private ActionRequestValidationException e;

        public static ValidationContext forTreeRoot(Collection<AggregationBuilder> siblingAggregations, Collection<PipelineAggregationBuilder> siblingPipelineAggregations, ActionRequestValidationException validationFailuresSoFar) {
            return new ForTreeRoot(siblingAggregations, siblingPipelineAggregations, validationFailuresSoFar);
        }

        public static ValidationContext forInsideTree(AggregationBuilder parent, ActionRequestValidationException validationFailuresSoFar) {
            return new ForInsideTree(parent, validationFailuresSoFar);
        }

        private ValidationContext(ActionRequestValidationException validationFailuresSoFar) {
            this.e = validationFailuresSoFar;
        }

        public abstract Collection<AggregationBuilder> getSiblingAggregations();

        public abstract Collection<PipelineAggregationBuilder> getSiblingPipelineAggregations();

        public void addValidationError(String error) {
            this.e = ValidateActions.addValidationError((String)error, (ActionRequestValidationException)this.e);
        }

        public void addBucketPathValidationError(String error) {
            this.addValidationError(Parser.BUCKETS_PATH.getPreferredName() + " " + error);
        }

        public abstract void validateHasParent(String var1, String var2);

        public abstract void validateParentAggSequentiallyOrdered(String var1, String var2);

        public ActionRequestValidationException getValidationException() {
            return this.e;
        }

        private static class ForTreeRoot
        extends ValidationContext {
            private final Collection<AggregationBuilder> siblingAggregations;
            private final Collection<PipelineAggregationBuilder> siblingPipelineAggregations;

            ForTreeRoot(Collection<AggregationBuilder> siblingAggregations, Collection<PipelineAggregationBuilder> siblingPipelineAggregations, ActionRequestValidationException validationFailuresSoFar) {
                super(validationFailuresSoFar);
                this.siblingAggregations = Objects.requireNonNull(siblingAggregations);
                this.siblingPipelineAggregations = Objects.requireNonNull(siblingPipelineAggregations);
            }

            @Override
            public Collection<AggregationBuilder> getSiblingAggregations() {
                return this.siblingAggregations;
            }

            @Override
            public Collection<PipelineAggregationBuilder> getSiblingPipelineAggregations() {
                return this.siblingPipelineAggregations;
            }

            @Override
            public void validateHasParent(String type, String name) {
                this.addValidationError(type + " aggregation [" + name + "] must be declared inside of another aggregation");
            }

            @Override
            public void validateParentAggSequentiallyOrdered(String type, String name) {
                this.addValidationError(type + " aggregation [" + name + "] must have a histogram, date_histogram or auto_date_histogram as parent but doesn't have a parent");
            }
        }

        private static class ForInsideTree
        extends ValidationContext {
            private final AggregationBuilder parent;

            ForInsideTree(AggregationBuilder parent, ActionRequestValidationException validationFailuresSoFar) {
                super(validationFailuresSoFar);
                this.parent = Objects.requireNonNull(parent);
            }

            @Override
            public Collection<AggregationBuilder> getSiblingAggregations() {
                return this.parent.getSubAggregations();
            }

            @Override
            public Collection<PipelineAggregationBuilder> getSiblingPipelineAggregations() {
                return this.parent.getPipelineAggregations();
            }

            @Override
            public void validateHasParent(String type, String name) {
            }

            @Override
            public void validateParentAggSequentiallyOrdered(String type, String name) {
                String error = this.parent.validateParentAgg(type, name);
                if (error != null) {
                    this.addValidationError(error);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface Parser {
        public static final ParseField BUCKETS_PATH = new ParseField("buckets_path", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
        public static final ParseField GAP_POLICY = new ParseField("gap_policy", new String[0]);

        public PipelineAggregationBuilder parse(String var1, XContentParser var2) throws IOException;
    }
}

