/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.values;

import io.skylite.common.index.fielddata.DocValueBits;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.AggregationScript;
import io.skylite.core.aggregations.values.ScriptBytesValues;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.common.Rounding;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexOrdinalsFieldData;
import io.skylite.core.index.fielddata.LeafOrdinalsFieldData;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortingBinaryDocValues;
import io.skylite.core.lucene.ScorerAware;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

public abstract class BytesValuesSource
extends ValuesSource {
    @Override
    public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
        SortedBinaryDocValues bytes = this.bytesValues(context);
        return io.skylite.core.index.fielddata.FieldData.docsWithValue(bytes);
    }

    @Override
    public final Function<Rounding, Rounding.Prepared> roundingPreparer() throws IOException {
        throw new AggregationExecutionException("can't round a [BYTES]");
    }

    public static class WithScript
    extends BytesValuesSource {
        private final ValuesSource delegate;
        private final AggregationScript.LeafFactory script;

        public WithScript(ValuesSource delegate, AggregationScript.LeafFactory script) {
            this.delegate = delegate;
            this.script = script;
        }

        @Override
        public boolean needsScores() {
            return this.script.needs_score();
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return new BytesValues(this.delegate.bytesValues(context), this.script.newInstance(context));
        }

        static class BytesValues
        extends SortingBinaryDocValues
        implements ScorerAware {
            private final SortedBinaryDocValues bytesValues;
            private final AggregationScript script;

            BytesValues(SortedBinaryDocValues bytesValues, AggregationScript script) {
                this.bytesValues = bytesValues;
                this.script = script;
            }

            @Override
            public void setScorer(Scorable scorer) {
                this.script.setScorer(scorer);
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (this.bytesValues.advanceExact(doc)) {
                    this.count = this.bytesValues.docValueCount();
                    this.grow();
                    this.script.setDocument(doc);
                    for (int i = 0; i < this.count; ++i) {
                        BytesRef value = this.bytesValues.nextValue();
                        this.script.setNextAggregationValue(value.utf8ToString());
                        Object run = this.script.execute();
                        CollectionUtils.ensureNoSelfReferences(run, "ValuesSource.BytesValues script");
                        this.values[i].copyChars((CharSequence)run.toString());
                    }
                    this.sort();
                    return true;
                }
                this.count = 0;
                this.grow();
                return false;
            }
        }
    }

    public static class Script
    extends BytesValuesSource {
        private final AggregationScript.LeafFactory script;

        public Script(AggregationScript.LeafFactory script) {
            this.script = script;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return new ScriptBytesValues(this.script.newInstance(context));
        }

        @Override
        public boolean needsScores() {
            return this.script.needs_score();
        }
    }

    public static class FieldData
    extends BytesValuesSource {
        protected final IndexFieldData<?> indexFieldData;

        public FieldData(IndexFieldData<?> indexFieldData) {
            this.indexFieldData = indexFieldData;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return this.indexFieldData.load(context).getBytesValues();
        }
    }

    public static abstract class WithOrdinals
    extends BytesValuesSource {
        public static final WithOrdinals EMPTY = new WithOrdinals(){

            @Override
            public SortedSetDocValues ordinalsValues(LeafReaderContext context) {
                return DocValues.emptySortedSet();
            }

            @Override
            public SortedSetDocValues globalOrdinalsValues(LeafReaderContext context) {
                return DocValues.emptySortedSet();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return io.skylite.core.index.fielddata.FieldData.emptySortedBinary();
            }

            @Override
            public LongUnaryOperator globalOrdinalsMapping(LeafReaderContext context) throws IOException {
                return LongUnaryOperator.identity();
            }
        };

        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            SortedSetDocValues ordinals = this.ordinalsValues(context);
            return io.skylite.core.index.fielddata.FieldData.docsWithValue(ordinals);
        }

        public abstract SortedSetDocValues ordinalsValues(LeafReaderContext var1) throws IOException;

        public abstract SortedSetDocValues globalOrdinalsValues(LeafReaderContext var1) throws IOException;

        public boolean supportsGlobalOrdinalsMapping() {
            return true;
        }

        @Override
        public boolean hasGlobalOrdinals() {
            return true;
        }

        public abstract LongUnaryOperator globalOrdinalsMapping(LeafReaderContext var1) throws IOException;

        public long globalMaxOrd(IndexSearcher indexSearcher) throws IOException {
            IndexReader indexReader = indexSearcher.getIndexReader();
            if (indexReader.leaves().isEmpty()) {
                return 0L;
            }
            LeafReaderContext atomicReaderContext = (LeafReaderContext)indexReader.leaves().get(0);
            SortedSetDocValues values = this.globalOrdinalsValues(atomicReaderContext);
            return values.getValueCount();
        }

        public static class FieldData
        extends WithOrdinals {
            protected final IndexOrdinalsFieldData indexFieldData;

            public FieldData(IndexOrdinalsFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)this.indexFieldData.load(context);
                return atomicFieldData.getBytesValues();
            }

            @Override
            public SortedSetDocValues ordinalsValues(LeafReaderContext context) {
                LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)this.indexFieldData.load(context);
                return atomicFieldData.getOrdinalsValues();
            }

            @Override
            public SortedSetDocValues globalOrdinalsValues(LeafReaderContext context) {
                IndexOrdinalsFieldData global = this.indexFieldData.loadGlobal((DirectoryReader)context.parent.reader());
                LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)global.load(context);
                return atomicFieldData.getOrdinalsValues();
            }

            @Override
            public boolean supportsGlobalOrdinalsMapping() {
                return this.indexFieldData.supportsGlobalOrdinalsMapping();
            }

            @Override
            public LongUnaryOperator globalOrdinalsMapping(LeafReaderContext context) throws IOException {
                IndexOrdinalsFieldData global = this.indexFieldData.loadGlobal((DirectoryReader)context.parent.reader());
                OrdinalMap map = global.getOrdinalMap();
                if (map == null) {
                    return LongUnaryOperator.identity();
                }
                LongValues segmentToGlobalOrd = map.getGlobalOrds(context.ord);
                return arg_0 -> ((LongValues)segmentToGlobalOrd).get(arg_0);
            }
        }
    }
}

