/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.values;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.AggregationScript;
import io.skylite.core.aggregations.FieldContext;
import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.MissingValues;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.RangeValuesSource;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.Rounding;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.common.time.DateResolution;
import io.skylite.core.index.fielddata.DocValueDateFormatters;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.IndexOrdinalsFieldData;
import io.skylite.core.mapper.DateFieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.RangeFieldMapper;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.BytesRef;

public enum CoreValuesSourceType implements ValuesSourceType
{
    NUMERIC{

        @Override
        public ValuesSource getEmpty() {
            return NumericValuesSource.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return new NumericValuesSource.Script(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            if (!(fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            NumericValuesSource dataSource = new NumericValuesSource.FieldData((IndexNumericFieldData)fieldContext.indexFieldData());
            if (script != null) {
                dataSource = new NumericValuesSource.WithScript(dataSource, script);
            }
            return dataSource;
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            Double missing = docValueFormat.parseDouble(rawMissing.toString(), false, context::nowInMillis);
            return MissingValues.replaceMissing((NumericValuesSource)valuesSource, missing);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }
    }
    ,
    BYTES{

        @Override
        public ValuesSource getEmpty() {
            return BytesValuesSource.WithOrdinals.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return new BytesValuesSource.Script(script);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            IndexFieldData<?> indexFieldData = fieldContext.indexFieldData();
            BytesValuesSource dataSource = indexFieldData instanceof IndexOrdinalsFieldData ? new BytesValuesSource.WithOrdinals.FieldData((IndexOrdinalsFieldData)indexFieldData) : new BytesValuesSource.FieldData(indexFieldData);
            if (script != null) {
                dataSource = new BytesValuesSource.WithScript(dataSource, script);
            }
            return dataSource;
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            BytesRef missing = docValueFormat.parseBytesRef(rawMissing.toString());
            if (valuesSource instanceof BytesValuesSource.WithOrdinals) {
                return MissingValues.replaceMissing((BytesValuesSource.WithOrdinals)valuesSource, missing);
            }
            return MissingValues.replaceMissing((BytesValuesSource)valuesSource, missing);
        }
    }
    ,
    RANGE{

        @Override
        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Can't deal with unmapped ValuesSource type " + this.value());
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("value source of type [" + this.value() + "] is not supported by scripts");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            MappedFieldType fieldType = fieldContext.fieldType();
            if (!(fieldType instanceof RangeFieldMapper.RangeFieldType)) {
                throw new IllegalStateException("Asked for range ValuesSource, but field is of type " + fieldType.name());
            }
            RangeFieldMapper.RangeFieldType rangeFieldType = (RangeFieldMapper.RangeFieldType)fieldType;
            return new RangeValuesSource(fieldContext.indexFieldData(), rangeFieldType.rangeType());
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            throw new IllegalArgumentException("Can't apply missing values on a " + String.valueOf(valuesSource.getClass()));
        }
    }
    ,
    IP{

        @Override
        public ValuesSource getEmpty() {
            return BYTES.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return BYTES.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            return BYTES.getField(fieldContext, script, context);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return BYTES.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.IP;
        }
    }
    ,
    DATE{

        @Override
        public ValuesSource getEmpty() {
            return NUMERIC.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return NUMERIC.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            NumericValuesSource dataSource = this.fieldData(fieldContext, context);
            if (script != null) {
                return new NumericValuesSource.WithScript(dataSource, script);
            }
            return dataSource;
        }

        private NumericValuesSource fieldData(final FieldContext fieldContext, final AggregationContext context) {
            if (!(fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            if (!(fieldContext.fieldType() instanceof DateFieldMapper.DateFieldType)) {
                return new NumericValuesSource.FieldData((IndexNumericFieldData)fieldContext.indexFieldData());
            }
            return new NumericValuesSource.FieldData(this, (IndexNumericFieldData)fieldContext.indexFieldData()){

                @Override
                public Function<Rounding, Rounding.Prepared> roundingPreparer() throws IOException {
                    byte[] min;
                    final DateFieldMapper.DateFieldType dft = (DateFieldMapper.DateFieldType)fieldContext.fieldType();
                    final long[] range = new long[]{Long.MIN_VALUE, Long.MAX_VALUE};
                    if (fieldContext.fieldType().isSearchable() && (min = PointValues.getMinPackedValue((IndexReader)context.searcher().getIndexReader(), (String)fieldContext.field())) != null) {
                        byte[] max = PointValues.getMaxPackedValue((IndexReader)context.searcher().getIndexReader(), (String)fieldContext.field());
                        range[0] = dft.resolution().parsePointAsMillis(min);
                        range[1] = dft.resolution().parsePointAsMillis(max);
                    }
                    if (context.query() != null) {
                        context.query().visit(new QueryVisitor(){

                            public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                                if (occur != BooleanClause.Occur.MUST) {
                                    return QueryVisitor.EMPTY_VISITOR;
                                }
                                return this;
                            }

                            public boolean acceptField(String field) {
                                return field.equals(fieldContext.fieldType().name());
                            }

                            public void visitLeaf(Query query) {
                                if (query instanceof PointRangeQuery) {
                                    PointRangeQuery prq = (PointRangeQuery)query;
                                    range[0] = Math.max(range[0], dft.resolution().parsePointAsMillis(prq.getLowerPoint()));
                                    range[1] = Math.min(range[1], dft.resolution().parsePointAsMillis(prq.getUpperPoint()));
                                }
                            }
                        });
                    }
                    if (range[0] == Long.MIN_VALUE && range[1] == Long.MAX_VALUE) {
                        return Rounding::prepareForUnknown;
                    }
                    return rounding -> rounding.prepare(range[0], range[1]);
                }
            };
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return NUMERIC.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return new DocValueDateFormatters.DateTime(format == null ? DateFormatter.getDefaultDateTimeFormatter() : DateFormatter.forPattern(format), tz == null ? ZoneOffset.UTC : tz, DateResolution.MILLISECONDS);
        }
    }
    ,
    BOOLEAN{

        @Override
        public ValuesSource getEmpty() {
            return NUMERIC.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return NUMERIC.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            return NUMERIC.getField(fieldContext, script, context);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return NUMERIC.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.BOOLEAN;
        }
    };

    public static final List<ValuesSourceType> ALL_CORE;

    public static ValuesSourceType fromString(String name) {
        return CoreValuesSourceType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    @Override
    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String typeName() {
        return this.value();
    }

    static {
        ALL_CORE = Arrays.asList(CoreValuesSourceType.values());
    }
}

