/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.values;

import io.skylite.common.index.fielddata.DocValueBits;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.common.Rounding;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.geo.AbstractGeoShapeIndexFieldData;
import io.skylite.core.index.fielddata.geo.GeoFieldData;
import io.skylite.core.index.fielddata.geo.GeoShapeValue;
import io.skylite.core.index.fielddata.geo.LeafGeoShapeFieldData;
import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;

public abstract class GeoShapeValuesSource
extends ValuesSource {
    public static final GeoShapeValuesSource EMPTY = new GeoShapeValuesSource(){

        @Override
        public GeoShapeValue getGeoShapeValues(LeafReaderContext context) {
            return GeoFieldData.emptyGeoShape();
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return io.skylite.core.index.fielddata.FieldData.emptySortedBinary();
        }
    };

    @Override
    public DocValueBits docsWithValue(LeafReaderContext context) {
        GeoShapeValue geoShapeValue = this.getGeoShapeValues(context);
        return GeoFieldData.docsWithValue(geoShapeValue);
    }

    @Override
    public Function<Rounding, Rounding.Prepared> roundingPreparer() {
        throw new AggregationExecutionException("can't round a [GEO_SHAPE]");
    }

    public abstract GeoShapeValue getGeoShapeValues(LeafReaderContext var1);

    public static class FieldData
    extends GeoShapeValuesSource {
        protected final AbstractGeoShapeIndexFieldData indexFieldData;

        public FieldData(AbstractGeoShapeIndexFieldData indexFieldData) {
            this.indexFieldData = indexFieldData;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return ((LeafGeoShapeFieldData)this.indexFieldData.load(context)).getBytesValues();
        }

        @Override
        public GeoShapeValue getGeoShapeValues(LeafReaderContext context) {
            return ((LeafGeoShapeFieldData)this.indexFieldData.load(context)).getGeoShapeValue();
        }
    }
}

