/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.values;

import io.skylite.SkyliteParseException;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.utils.WellKnownText;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.AggregationScript;
import io.skylite.core.aggregations.FieldContext;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.GeoShapeValuesSource;
import io.skylite.core.aggregations.values.MissingValues;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.geo.DocValueGeoFormatters;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.geo.AbstractGeoShapeIndexFieldData;
import io.skylite.core.index.fielddata.geo.IndexGeoPointFieldData;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum GeoValuesSourceType implements ValuesSourceType
{
    GEOPOINT{

        @Override
        public ValuesSource getEmpty() {
            return GeoPointValuesSource.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("value source of type [" + this.value() + "] is not supported by scripts");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            if (!(fieldContext.indexFieldData() instanceof IndexGeoPointFieldData)) {
                throw new IllegalArgumentException("Expected geo_point type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            return new GeoPointValuesSource.Fielddata((IndexGeoPointFieldData)fieldContext.indexFieldData());
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            GeoPoint missing = new GeoPoint(rawMissing.toString());
            return MissingValues.replaceMissing((GeoPointValuesSource)valuesSource, missing);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueGeoFormatters.GEOHASH;
        }
    }
    ,
    GEO_SHAPE{

        @Override
        public ValuesSource getEmpty() {
            return GeoShapeValuesSource.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException(String.format(Locale.ROOT, "value source of type [%s] is not supported by scripts", this.value()));
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            if (!(fieldContext.indexFieldData() instanceof AbstractGeoShapeIndexFieldData)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected geo_shape type on field [%s], but got [%s]", fieldContext.field(), fieldContext.fieldType().typeName()));
            }
            return new GeoShapeValuesSource.FieldData((AbstractGeoShapeIndexFieldData)fieldContext.indexFieldData());
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            try {
                Geometry geometry = WellKnownText.INSTANCE.fromWKT((String)rawMissing);
                return MissingValues.replaceMissing((GeoShapeValuesSource)valuesSource, geometry);
            }
            catch (Exception e) {
                throw new SkyliteParseException(String.format(Locale.ROOT, "Unable to parse the missing value [%s] provided in the input.", rawMissing), (Throwable)e, new Object[0]);
            }
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.RAW;
        }
    };

    public static final List<ValuesSourceType> ALL;

    public static GeoValuesSourceType fromString(String name) {
        return GeoValuesSourceType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    static {
        ALL = Arrays.asList(GeoValuesSourceType.values());
    }
}

