/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.values;

import io.skylite.common.index.fielddata.DocValueBits;
import io.skylite.core.aggregations.AggregationScript;
import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.ScriptBytesValues;
import io.skylite.core.aggregations.values.ScriptDoubleValues;
import io.skylite.core.aggregations.values.ScriptLongValues;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValueTypes;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.common.Rounding;
import io.skylite.core.index.fielddata.AbstractSortingNumericDocValues;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.index.fielddata.SortingNumericDoubleValues;
import io.skylite.core.lucene.ScorerAware;
import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Scorable;

public abstract class NumericValuesSource
extends ValuesSource {
    public static final NumericValuesSource EMPTY = new NumericValuesSource(){

        @Override
        public boolean isFloatingPoint() {
            return false;
        }

        @Override
        public boolean isBigInteger() {
            return false;
        }

        @Override
        public SortedNumericDocValues longValues(LeafReaderContext context) {
            return DocValues.emptySortedNumeric();
        }

        @Override
        public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
            return io.skylite.core.index.fielddata.FieldData.emptySortedNumericDoubles();
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return io.skylite.core.index.fielddata.FieldData.emptySortedBinary();
        }
    };

    public abstract boolean isFloatingPoint();

    public abstract boolean isBigInteger();

    public abstract SortedNumericDocValues longValues(LeafReaderContext var1) throws IOException;

    public abstract SortedNumericDoubleValues doubleValues(LeafReaderContext var1) throws IOException;

    @Override
    public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
        if (this.isFloatingPoint() || this.isBigInteger()) {
            SortedNumericDoubleValues values = this.doubleValues(context);
            return io.skylite.core.index.fielddata.FieldData.docsWithValue(values);
        }
        SortedNumericDocValues values = this.longValues(context);
        return io.skylite.core.index.fielddata.FieldData.docsWithValue(values);
    }

    @Override
    public Function<Rounding, Rounding.Prepared> roundingPreparer() throws IOException {
        return Rounding::prepareForUnknown;
    }

    public static class Script
    extends NumericValuesSource {
        private final AggregationScript.LeafFactory script;
        private final ValueType scriptValueType;

        public Script(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            this.script = script;
            this.scriptValueType = scriptValueType;
        }

        @Override
        public boolean isFloatingPoint() {
            return this.scriptValueType != null ? this.scriptValueType == ValueTypes.DOUBLE : true;
        }

        @Override
        public boolean isBigInteger() {
            return this.scriptValueType != null ? this.scriptValueType == ValueTypes.UNSIGNED_LONG : false;
        }

        @Override
        public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
            return new ScriptLongValues(this.script.newInstance(context));
        }

        @Override
        public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
            return new ScriptDoubleValues(this.script.newInstance(context));
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return new ScriptBytesValues(this.script.newInstance(context));
        }

        @Override
        public boolean needsScores() {
            return this.script.needs_score();
        }
    }

    public static class FieldData
    extends NumericValuesSource {
        protected final IndexNumericFieldData indexFieldData;

        public FieldData(IndexNumericFieldData indexFieldData) {
            this.indexFieldData = indexFieldData;
        }

        @Override
        public boolean isFloatingPoint() {
            return this.indexFieldData.getNumericType().isFloatingPoint();
        }

        @Override
        public boolean isBigInteger() {
            return this.indexFieldData.getNumericType() == IndexNumericFieldData.NumericType.UNSIGNED_LONG;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return ((LeafNumericFieldData)this.indexFieldData.load(context)).getBytesValues();
        }

        @Override
        public SortedNumericDocValues longValues(LeafReaderContext context) {
            return ((LeafNumericFieldData)this.indexFieldData.load(context)).getLongValues();
        }

        @Override
        public SortedNumericDoubleValues doubleValues(LeafReaderContext context) {
            return ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
        }
    }

    public static class WithScript
    extends NumericValuesSource {
        private final NumericValuesSource delegate;
        private final AggregationScript.LeafFactory script;

        public WithScript(NumericValuesSource delegate, AggregationScript.LeafFactory script) {
            this.delegate = delegate;
            this.script = script;
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }

        @Override
        public boolean isBigInteger() {
            return false;
        }

        @Override
        public boolean needsScores() {
            return this.script.needs_score();
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
            return new BytesValuesSource.WithScript.BytesValues(this.delegate.bytesValues(context), this.script.newInstance(context));
        }

        @Override
        public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
            return new LongValues(this.delegate.longValues(context), this.script.newInstance(context));
        }

        @Override
        public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
            return new DoubleValues(this.delegate.doubleValues(context), this.script.newInstance(context));
        }

        static class LongValues
        extends AbstractSortingNumericDocValues
        implements ScorerAware {
            private final SortedNumericDocValues longValues;
            private final AggregationScript script;

            LongValues(SortedNumericDocValues values, AggregationScript script) {
                this.longValues = values;
                this.script = script;
            }

            @Override
            public void setScorer(Scorable scorer) {
                this.script.setScorer(scorer);
            }

            public boolean advanceExact(int target) throws IOException {
                if (this.longValues.advanceExact(target)) {
                    this.resize(this.longValues.docValueCount());
                    this.script.setDocument(target);
                    for (int i = 0; i < this.docValueCount(); ++i) {
                        this.script.setNextAggregationValue(this.longValues.nextValue());
                        this.values[i] = this.script.runAsLong();
                    }
                    this.sort();
                    return true;
                }
                return false;
            }
        }

        static class DoubleValues
        extends SortingNumericDoubleValues
        implements ScorerAware {
            private final SortedNumericDoubleValues doubleValues;
            private final AggregationScript script;

            DoubleValues(SortedNumericDoubleValues values, AggregationScript script) {
                this.doubleValues = values;
                this.script = script;
            }

            @Override
            public void setScorer(Scorable scorer) {
                this.script.setScorer(scorer);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                if (this.doubleValues.advanceExact(target)) {
                    this.resize(this.doubleValues.docValueCount());
                    this.script.setDocument(target);
                    for (int i = 0; i < this.docValueCount(); ++i) {
                        this.script.setNextAggregationValue(this.doubleValues.nextValue());
                        this.values[i] = this.script.runAsDouble();
                    }
                    this.sort();
                    return true;
                }
                return false;
            }

            @Override
            public int advance(int target) throws IOException {
                return this.doubleValues.advance(target);
            }
        }
    }
}

