/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.aggregations.values;

import io.skylite.common.index.fielddata.DocValueBits;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.common.Rounding;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.mapper.RangeType;
import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;

public class RangeValuesSource
extends ValuesSource {
    private final RangeType rangeType;
    protected final IndexFieldData<?> indexFieldData;

    public RangeValuesSource(IndexFieldData<?> indexFieldData, RangeType rangeType) {
        this.indexFieldData = indexFieldData;
        this.rangeType = rangeType;
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
        return this.indexFieldData.load(context).getBytesValues();
    }

    @Override
    public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
        SortedBinaryDocValues bytes = this.bytesValues(context);
        return FieldData.docsWithValue(bytes);
    }

    @Override
    public Function<Rounding, Rounding.Prepared> roundingPreparer() throws IOException {
        return Rounding::prepareForUnknown;
    }

    public RangeType rangeType() {
        return this.rangeType;
    }
}

