/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.analysis;

import io.skylite.Version;
import io.skylite.common.NamedRegistry;
import io.skylite.core.analysis.AnalysisProvider;
import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.analysis.AnalyzerProvider;
import io.skylite.core.analysis.CharFilterFactory;
import io.skylite.core.analysis.HunspellService;
import io.skylite.core.analysis.HunspellTokenFilterFactory;
import io.skylite.core.analysis.PreBuiltAnalyzerProviderFactory;
import io.skylite.core.analysis.PreBuiltCacheFactory;
import io.skylite.core.analysis.PreBuiltTokenizers;
import io.skylite.core.analysis.PreConfiguredCharFilter;
import io.skylite.core.analysis.PreConfiguredTokenFilter;
import io.skylite.core.analysis.PreConfiguredTokenizer;
import io.skylite.core.analysis.StandardAnalyzerProvider;
import io.skylite.core.analysis.TokenFilterFactory;
import io.skylite.core.analysis.TokenizerFactory;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.KeywordAnalyzerProvider;
import io.skylite.core.index.analysis.LowercaseNormalizerProvider;
import io.skylite.core.index.analysis.ShingleTokenFilterFactory;
import io.skylite.core.index.analysis.SimpleAnalyzerProvider;
import io.skylite.core.index.analysis.StandardTokenizerFactory;
import io.skylite.core.index.analysis.StopAnalyzerProvider;
import io.skylite.core.index.analysis.StopTokenFilterFactory;
import io.skylite.core.index.analysis.WhitespaceAnalyzerProvider;
import io.skylite.core.plugins.AnalysisPlugin;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.hunspell.Dictionary;

public final class AnalysisModule {
    public static final IndexSettings NA_INDEX_SETTINGS;
    private static final DeprecationLogger deprecationLogger;
    private final HunspellService hunspellService;
    private final AnalysisRegistry analysisRegistry;

    public AnalysisModule(Environment environment, List<AnalysisPlugin> plugins) throws IOException {
        NamedRegistry<AnalysisProvider<CharFilterFactory>> charFilters = this.setupCharFilters(plugins);
        NamedRegistry<Dictionary> hunspellDictionaries = this.setupHunspellDictionaries(plugins);
        this.hunspellService = new HunspellService(environment.settings(), environment, hunspellDictionaries.getRegistry());
        NamedRegistry<AnalysisProvider<TokenFilterFactory>> tokenFilters = this.setupTokenFilters(plugins, this.hunspellService);
        NamedRegistry<AnalysisProvider<TokenizerFactory>> tokenizers = this.setupTokenizers(plugins);
        NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> analyzers = this.setupAnalyzers(plugins);
        NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> normalizers = this.setupNormalizers(plugins);
        Map<String, PreConfiguredCharFilter> preConfiguredCharFilters = AnalysisModule.setupPreConfiguredCharFilters(plugins);
        Map<String, PreConfiguredTokenFilter> preConfiguredTokenFilters = AnalysisModule.setupPreConfiguredTokenFilters(plugins);
        Map<String, PreConfiguredTokenizer> preConfiguredTokenizers = AnalysisModule.setupPreConfiguredTokenizers(plugins);
        Map<String, PreBuiltAnalyzerProviderFactory> preConfiguredAnalyzers = AnalysisModule.setupPreBuiltAnalyzerProviderFactories(plugins);
        this.analysisRegistry = new AnalysisRegistry(environment, charFilters.getRegistry(), tokenFilters.getRegistry(), tokenizers.getRegistry(), analyzers.getRegistry(), normalizers.getRegistry(), preConfiguredCharFilters, preConfiguredTokenFilters, preConfiguredTokenizers, preConfiguredAnalyzers);
    }

    HunspellService getHunspellService() {
        return this.hunspellService;
    }

    public AnalysisRegistry getAnalysisRegistry() {
        return this.analysisRegistry;
    }

    private NamedRegistry<AnalysisProvider<CharFilterFactory>> setupCharFilters(List<AnalysisPlugin> plugins) {
        NamedRegistry charFilters = new NamedRegistry("char_filter");
        charFilters.extractAndRegister(plugins, AnalysisPlugin::getCharFilters);
        return charFilters;
    }

    public NamedRegistry<Dictionary> setupHunspellDictionaries(List<AnalysisPlugin> plugins) {
        NamedRegistry hunspellDictionaries = new NamedRegistry("dictionary");
        hunspellDictionaries.extractAndRegister(plugins, AnalysisPlugin::getHunspellDictionaries);
        return hunspellDictionaries;
    }

    private NamedRegistry<AnalysisProvider<TokenFilterFactory>> setupTokenFilters(List<AnalysisPlugin> plugins, HunspellService hunspellService) {
        NamedRegistry tokenFilters = new NamedRegistry("token_filter");
        tokenFilters.register("stop", StopTokenFilterFactory::new);
        tokenFilters.register("standard", (Object)new AnalysisProvider<TokenFilterFactory>(this){

            @Override
            public TokenFilterFactory get(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
                throw new IllegalArgumentException("The [standard] token filter has been removed.");
            }

            @Override
            public boolean requiresAnalysisSettings() {
                return false;
            }
        });
        tokenFilters.register("shingle", ShingleTokenFilterFactory::new);
        tokenFilters.register("hunspell", AnalysisPlugin.requiresAnalysisSettings((indexSettings, env, name, settings) -> new HunspellTokenFilterFactory(indexSettings, name, settings, hunspellService)));
        tokenFilters.extractAndRegister(plugins, AnalysisPlugin::getTokenFilters);
        return tokenFilters;
    }

    static Map<String, PreBuiltAnalyzerProviderFactory> setupPreBuiltAnalyzerProviderFactories(List<AnalysisPlugin> plugins) {
        NamedRegistry preConfiguredCharFilters = new NamedRegistry("pre-built analyzer");
        for (AnalysisPlugin plugin : plugins) {
            for (PreBuiltAnalyzerProviderFactory factory : plugin.getPreBuiltAnalyzerProviderFactories()) {
                preConfiguredCharFilters.register(factory.getName(), (Object)factory);
            }
        }
        return Collections.unmodifiableMap(preConfiguredCharFilters.getRegistry());
    }

    static Map<String, PreConfiguredCharFilter> setupPreConfiguredCharFilters(List<AnalysisPlugin> plugins) {
        NamedRegistry preConfiguredCharFilters = new NamedRegistry("pre-configured char_filter");
        for (AnalysisPlugin plugin : plugins) {
            for (PreConfiguredCharFilter filter : plugin.getPreConfiguredCharFilters()) {
                preConfiguredCharFilters.register(filter.getName(), (Object)filter);
            }
        }
        return Collections.unmodifiableMap(preConfiguredCharFilters.getRegistry());
    }

    static Map<String, PreConfiguredTokenFilter> setupPreConfiguredTokenFilters(List<AnalysisPlugin> plugins) {
        NamedRegistry preConfiguredTokenFilters = new NamedRegistry("pre-configured token_filter");
        preConfiguredTokenFilters.register("lowercase", (Object)PreConfiguredTokenFilter.singleton("lowercase", true, LowerCaseFilter::new));
        preConfiguredTokenFilters.register("standard", (Object)PreConfiguredTokenFilter.openSearchVersion("standard", true, (reader, version) -> {
            throw new IllegalArgumentException("The [standard] token filter has been removed.");
        }));
        for (AnalysisPlugin plugin : plugins) {
            for (PreConfiguredTokenFilter filter : plugin.getPreConfiguredTokenFilters()) {
                preConfiguredTokenFilters.register(filter.getName(), (Object)filter);
            }
        }
        return Collections.unmodifiableMap(preConfiguredTokenFilters.getRegistry());
    }

    static Map<String, PreConfiguredTokenizer> setupPreConfiguredTokenizers(List<AnalysisPlugin> plugins) {
        NamedRegistry preConfiguredTokenizers = new NamedRegistry("pre-configured tokenizer");
        for (PreBuiltTokenizers preBuiltTokenizers : PreBuiltTokenizers.values()) {
            String name = preBuiltTokenizers.name().toLowerCase(Locale.ROOT);
            preConfiguredTokenizers.register(name, (Object)(switch (preBuiltTokenizers.getCachingStrategy()) {
                case PreBuiltCacheFactory.CachingStrategy.ONE -> PreConfiguredTokenizer.singleton(name, () -> preBuiltTokenizers.create(Version.CURRENT));
                default -> throw new UnsupportedOperationException("Caching strategy unsupported by temporary shim [" + String.valueOf((Object)preBuiltTokenizers) + "]");
            }));
        }
        for (AnalysisPlugin plugin : plugins) {
            for (PreConfiguredTokenizer preConfiguredTokenizer : plugin.getPreConfiguredTokenizers()) {
                preConfiguredTokenizers.register(preConfiguredTokenizer.getName(), (Object)preConfiguredTokenizer);
            }
        }
        return Collections.unmodifiableMap(preConfiguredTokenizers.getRegistry());
    }

    private NamedRegistry<AnalysisProvider<TokenizerFactory>> setupTokenizers(List<AnalysisPlugin> plugins) {
        NamedRegistry tokenizers = new NamedRegistry("tokenizer");
        tokenizers.register("standard", StandardTokenizerFactory::new);
        tokenizers.extractAndRegister(plugins, AnalysisPlugin::getTokenizers);
        return tokenizers;
    }

    private NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> setupAnalyzers(List<AnalysisPlugin> plugins) {
        NamedRegistry analyzers = new NamedRegistry("analyzer");
        analyzers.register("default", StandardAnalyzerProvider::new);
        analyzers.register("standard", StandardAnalyzerProvider::new);
        analyzers.register("simple", SimpleAnalyzerProvider::new);
        analyzers.register("stop", StopAnalyzerProvider::new);
        analyzers.register("whitespace", WhitespaceAnalyzerProvider::new);
        analyzers.register("keyword", KeywordAnalyzerProvider::new);
        analyzers.extractAndRegister(plugins, AnalysisPlugin::getAnalyzers);
        return analyzers;
    }

    private NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> setupNormalizers(List<AnalysisPlugin> plugins) {
        NamedRegistry normalizers = new NamedRegistry("normalizer");
        normalizers.register("lowercase", LowercaseNormalizerProvider::new);
        return normalizers;
    }

    static {
        Settings build = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 1).put("index.number_of_shards", 1).build();
        IndexMetadata metadata = IndexMetadata.builder("_na_").settings(build).build();
        NA_INDEX_SETTINGS = new IndexSettings(metadata, Settings.EMPTY);
        deprecationLogger = DeprecationLogger.getLogger(AnalysisModule.class);
    }
}

