/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.analysis;

import io.skylite.Version;
import io.skylite.core.analysis.AnalysisProvider;
import io.skylite.core.analysis.PreBuiltCacheFactory;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.io.IOException;

public abstract class PreConfiguredAnalysisComponent<T>
implements AnalysisProvider<T> {
    protected final String name;
    protected final PreBuiltCacheFactory.PreBuiltCache<T> cache;

    protected PreConfiguredAnalysisComponent(String name, PreBuiltCacheFactory.CachingStrategy cache) {
        this.name = name;
        this.cache = PreBuiltCacheFactory.getCache(cache);
    }

    protected PreConfiguredAnalysisComponent(String name, PreBuiltCacheFactory.PreBuiltCache<T> cache) {
        this.name = name;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        Version versionCreated = IndexMetadata.indexCreated(settings);
        PreConfiguredAnalysisComponent preConfiguredAnalysisComponent = this;
        synchronized (preConfiguredAnalysisComponent) {
            T factory = this.cache.get(versionCreated);
            if (factory == null) {
                factory = this.create(versionCreated);
                this.cache.put(versionCreated, factory);
            }
            return factory;
        }
    }

    public String getName() {
        return this.name;
    }

    protected abstract T create(Version var1);
}

