/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.analysis;

import io.skylite.core.analysis.AnalysisMode;
import io.skylite.core.analysis.CharFilterFactory;
import io.skylite.core.analysis.TokenizerFactory;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;

public interface TokenFilterFactory {
    public static final TokenFilterFactory IDENTITY_FILTER = new TokenFilterFactory(){

        @Override
        public String name() {
            return "identity";
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            return tokenStream;
        }
    };

    public String name();

    public TokenStream create(TokenStream var1);

    default public TokenStream normalize(TokenStream tokenStream) {
        return tokenStream;
    }

    default public boolean breaksFastVectorHighlighter() {
        return false;
    }

    default public TokenFilterFactory getChainAwareTokenFilterFactory(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        return this;
    }

    default public TokenFilterFactory getSynonymFilter() {
        return this;
    }

    default public AnalysisMode getAnalysisMode() {
        return AnalysisMode.ALL;
    }
}

