/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.blobstore;

import io.skylite.common.StreamContext;
import io.skylite.common.action.ActionListener;
import io.skylite.common.crypto.CryptoHandler;
import io.skylite.common.crypto.DecryptedRangedStreamProvider;
import io.skylite.common.io.InputStreamContainer;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.blobstore.AsyncMultiStreamBlobContainer;
import io.skylite.core.blobstore.EncryptedBlobContainer;
import io.skylite.core.blobstore.stream.read.ReadContext;
import io.skylite.core.blobstore.stream.write.WriteContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AsyncMultiStreamEncryptedBlobContainer<T, U>
extends EncryptedBlobContainer<T, U>
implements AsyncMultiStreamBlobContainer {
    private final AsyncMultiStreamBlobContainer blobContainer;
    private final CryptoHandler<T, U> cryptoHandler;

    public AsyncMultiStreamEncryptedBlobContainer(AsyncMultiStreamBlobContainer blobContainer, CryptoHandler<T, U> cryptoHandler) {
        super(blobContainer, cryptoHandler);
        this.blobContainer = blobContainer;
        this.cryptoHandler = cryptoHandler;
    }

    @Override
    public void asyncBlobUpload(WriteContext writeContext, ActionListener<Void> completionListener) throws IOException {
        EncryptedWriteContext<T, U> encryptedWriteContext = new EncryptedWriteContext<T, U>(writeContext, this.cryptoHandler);
        this.blobContainer.asyncBlobUpload(encryptedWriteContext, completionListener);
    }

    @Override
    public void readBlobAsync(String blobName, ActionListener<ReadContext> listener) {
        try {
            Object cryptoContext = this.cryptoHandler.loadEncryptionMetadata(this.getEncryptedHeaderContentSupplier(blobName));
            ActionListener decryptingCompletionListener = ActionListenerHelper.map(listener, readContext -> new DecryptedReadContext<T, Object>((ReadContext)readContext, this.cryptoHandler, cryptoContext));
            this.blobContainer.readBlobAsync(blobName, decryptingCompletionListener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public boolean remoteIntegrityCheckSupported() {
        return false;
    }

    static class EncryptedWriteContext<T, U>
    extends WriteContext {
        private final T encryptionMetadata;
        private final CryptoHandler<T, U> cryptoHandler;
        private final long fileSize;

        public EncryptedWriteContext(WriteContext writeContext, CryptoHandler<T, U> cryptoHandler) {
            super(writeContext);
            this.cryptoHandler = cryptoHandler;
            this.encryptionMetadata = this.cryptoHandler.initEncryptionMetadata();
            this.fileSize = this.cryptoHandler.estimateEncryptedLengthOfEntireContent(this.encryptionMetadata, writeContext.getFileSize());
        }

        @Override
        public StreamContext getStreamProvider(long partSize) {
            long adjustedPartSize = this.cryptoHandler.adjustContentSizeForPartialEncryption(this.encryptionMetadata, partSize);
            StreamContext streamContext = super.getStreamProvider(adjustedPartSize);
            return new EncryptedStreamContext<T, U>(streamContext, this.cryptoHandler, this.encryptionMetadata);
        }

        @Override
        public long getFileSize() {
            return this.fileSize;
        }
    }

    static class DecryptedReadContext<T, U>
    extends ReadContext {
        private final CryptoHandler<T, U> cryptoHandler;
        private final U cryptoContext;
        private Long blobSize;

        public DecryptedReadContext(ReadContext readContext, CryptoHandler<T, U> cryptoHandler, U cryptoContext) {
            super(readContext);
            this.cryptoHandler = cryptoHandler;
            this.cryptoContext = cryptoContext;
        }

        @Override
        public long getBlobSize() {
            if (this.blobSize == null) {
                this.blobSize = this.cryptoHandler.estimateDecryptedLength(this.cryptoContext, super.getBlobSize());
            }
            return this.blobSize;
        }

        @Override
        public List<ReadContext.StreamPartCreator> getPartStreams() {
            return super.getPartStreams().stream().map(supplier -> () -> ((CompletableFuture)supplier.get()).thenApply(this::decryptInputStreamContainer)).collect(Collectors.toUnmodifiableList());
        }

        private InputStreamContainer decryptInputStreamContainer(InputStreamContainer inputStreamContainer) {
            long startOfStream = inputStreamContainer.getOffset();
            long endOfStream = startOfStream + inputStreamContainer.getContentLength() - 1L;
            DecryptedRangedStreamProvider decryptedStreamProvider = this.cryptoHandler.createDecryptingStreamOfRange(this.cryptoContext, startOfStream, endOfStream);
            long adjustedPos = decryptedStreamProvider.getAdjustedRange()[0];
            long adjustedLength = decryptedStreamProvider.getAdjustedRange()[1] - adjustedPos + 1L;
            InputStream decryptedStream = (InputStream)decryptedStreamProvider.getDecryptedStreamProvider().apply(inputStreamContainer.getInputStream());
            return new InputStreamContainer(decryptedStream, adjustedLength, adjustedPos);
        }
    }

    static class EncryptedStreamContext<T, U>
    extends StreamContext {
        private final CryptoHandler<T, U> cryptoHandler;
        private final T encryptionMetadata;

        public EncryptedStreamContext(StreamContext streamContext, CryptoHandler<T, U> cryptoHandler, T encryptionMetadata) {
            super(streamContext);
            this.cryptoHandler = cryptoHandler;
            this.encryptionMetadata = encryptionMetadata;
        }

        public InputStreamContainer provideStream(int partNumber) throws IOException {
            InputStreamContainer inputStreamContainer = super.provideStream(partNumber);
            return this.cryptoHandler.createEncryptingStreamOfPart(this.encryptionMetadata, inputStreamContainer, this.getNumberOfParts(), partNumber);
        }
    }
}

