/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.blobstore;

import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.crypto.CryptoHandler;
import io.skylite.core.blobstore.AsyncMultiStreamBlobContainer;
import io.skylite.core.blobstore.AsyncMultiStreamEncryptedBlobContainer;
import io.skylite.core.blobstore.BlobStore;
import io.skylite.core.blobstore.EncryptedBlobContainer;
import io.skylite.core.cluster.metadata.CryptoMetadata;
import io.skylite.core.crypto.CryptoHandlerRegistry;
import io.skylite.core.crypto.CryptoRegistryException;
import java.io.IOException;
import java.util.Map;

public class EncryptedBlobStore
implements BlobStore {
    private final BlobStore blobStore;
    private final CryptoHandler<?, ?> cryptoHandler;

    public EncryptedBlobStore(BlobStore blobStore, CryptoMetadata cryptoMetadata) {
        CryptoHandlerRegistry cryptoHandlerRegistry = CryptoHandlerRegistry.getInstance();
        assert (cryptoHandlerRegistry != null) : "CryptoManagerRegistry is not initialized";
        this.cryptoHandler = cryptoHandlerRegistry.fetchCryptoHandler(cryptoMetadata);
        if (this.cryptoHandler == null) {
            throw new CryptoRegistryException(cryptoMetadata.keyProviderName(), cryptoMetadata.keyProviderType(), "Crypto manager not found during encrypted blob store creation.");
        }
        this.blobStore = blobStore;
    }

    @Override
    public BlobContainer blobContainer(BlobPath path) {
        BlobContainer blobContainer = this.blobStore.blobContainer(path);
        if (blobContainer instanceof AsyncMultiStreamBlobContainer) {
            return new AsyncMultiStreamEncryptedBlobContainer((AsyncMultiStreamBlobContainer)blobContainer, this.cryptoHandler);
        }
        return new EncryptedBlobContainer(blobContainer, this.cryptoHandler);
    }

    @Override
    public Map<String, Long> stats() {
        return this.blobStore.stats();
    }

    @Override
    public Map<BlobStore.Metric, Map<String, Long>> extendedStats() {
        return this.blobStore.extendedStats();
    }

    @Override
    public void close() throws IOException {
        this.cryptoHandler.close();
        this.blobStore.close();
    }
}

