/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.blobstore.fs;

import io.skylite.SkyliteException;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.core.blobstore.BlobStore;
import io.skylite.core.blobstore.fs.FsBlobContainer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FsBlobStore
implements BlobStore {
    private final Path path;
    private final int bufferSizeInBytes;
    private final boolean readOnly;

    public FsBlobStore(int bufferSizeInBytes, Path path, boolean readonly) throws IOException {
        this.path = path;
        this.readOnly = readonly;
        if (!this.readOnly) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        this.bufferSizeInBytes = bufferSizeInBytes;
    }

    public String toString() {
        return this.path.toString();
    }

    public Path path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    @Override
    public BlobContainer blobContainer(BlobPath path) {
        try {
            return new FsBlobContainer(this, path, this.buildAndCreate(path));
        }
        catch (IOException ex) {
            throw new SkyliteException("failed to create blob container", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    public void close() {
    }

    protected synchronized Path buildAndCreate(BlobPath path) throws IOException {
        Path f = this.buildPath(path);
        if (!this.readOnly) {
            Files.createDirectories(f, new FileAttribute[0]);
        }
        return f;
    }

    private Path buildPath(BlobPath path) {
        String[] paths = path.toArray();
        if (paths.length == 0) {
            return this.path();
        }
        Path blobPath = this.path.resolve(paths[0]);
        if (paths.length > 1) {
            for (int i = 1; i < paths.length; ++i) {
                blobPath = blobPath.resolve(paths[i]);
            }
        }
        return blobPath;
    }
}

