/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionFuture;
import io.skylite.common.action.ActionListener;
import io.skylite.common.annotation.PublicApi;
import io.skylite.core.action.admin.indices.segments.IndicesSegmentResponse;
import io.skylite.core.action.admin.indices.segments.PitSegmentsRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkRequestBuilder;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.delete.DeleteRequestBuilder;
import io.skylite.core.action.explain.ExplainRequest;
import io.skylite.core.action.explain.ExplainRequestBuilder;
import io.skylite.core.action.explain.ExplainResponse;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesRequest;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesRequestBuilder;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesResponse;
import io.skylite.core.action.get.GetRequestBuilder;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetRequestBuilder;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.index.IndexRequestBuilder;
import io.skylite.core.action.search.ClearScrollRequest;
import io.skylite.core.action.search.ClearScrollRequestBuilder;
import io.skylite.core.action.search.ClearScrollResponse;
import io.skylite.core.action.search.CreatePitRequest;
import io.skylite.core.action.search.CreatePitResponse;
import io.skylite.core.action.search.DeletePitRequest;
import io.skylite.core.action.search.DeletePitResponse;
import io.skylite.core.action.search.GetAllPitNodesRequest;
import io.skylite.core.action.search.GetAllPitNodesResponse;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.search.MultiSearchRequestBuilder;
import io.skylite.core.action.search.MultiSearchResponse;
import io.skylite.core.action.search.SearchRequestBuilder;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.action.search.SearchScrollRequestBuilder;
import io.skylite.core.action.termvectors.MultiTermVectorsRequest;
import io.skylite.core.action.termvectors.MultiTermVectorsRequestBuilder;
import io.skylite.core.action.termvectors.MultiTermVectorsResponse;
import io.skylite.core.action.termvectors.TermVectorsRequest;
import io.skylite.core.action.termvectors.TermVectorsRequestBuilder;
import io.skylite.core.action.termvectors.TermVectorsResponse;
import io.skylite.core.action.update.UpdateRequestBuilder;
import io.skylite.core.client.AdminClient;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@PublicApi(since="1.0.0")
public interface Client
extends ReleasableSkyliteClient {
    public static final Setting<String> CLIENT_TYPE_SETTING_S = new Setting<String>("client.type", "node", s -> {
        switch (s) {
            case "node": 
            case "transport": {
                return s;
            }
        }
        throw new IllegalArgumentException("Can't parse [client.type] must be one of [node, transport]");
    }, Setting.Property.NodeScope);

    public AdminClient admin();

    public IndexRequestBuilder prepareIndex();

    public IndexRequestBuilder prepareIndex(String var1);

    public UpdateRequestBuilder prepareUpdate();

    public UpdateRequestBuilder prepareUpdate(String var1, String var2);

    public DeleteRequestBuilder prepareDelete();

    public DeleteRequestBuilder prepareDelete(String var1, String var2);

    public ActionFuture<BulkResponse> bulk(BulkRequest var1);

    public BulkRequestBuilder prepareBulk();

    public BulkRequestBuilder prepareBulk(@Nullable String var1);

    public GetRequestBuilder prepareGet();

    public GetRequestBuilder prepareGet(String var1, String var2);

    public ActionFuture<MultiGetResponse> multiGet(MultiGetRequest var1);

    public void multiGet(MultiGetRequest var1, ActionListener<MultiGetResponse> var2);

    public MultiGetRequestBuilder prepareMultiGet();

    public SearchRequestBuilder prepareSearch(String ... var1);

    public ActionFuture<SearchResponse> searchScroll(SearchScrollRequest var1);

    public void searchScroll(SearchScrollRequest var1, ActionListener<SearchResponse> var2);

    public SearchScrollRequestBuilder prepareSearchScroll(String var1);

    public void createPit(CreatePitRequest var1, ActionListener<CreatePitResponse> var2);

    public void deletePits(DeletePitRequest var1, ActionListener<DeletePitResponse> var2);

    public void getAllPits(GetAllPitNodesRequest var1, ActionListener<GetAllPitNodesResponse> var2);

    public void pitSegments(PitSegmentsRequest var1, ActionListener<IndicesSegmentResponse> var2);

    public ActionFuture<MultiSearchResponse> multiSearch(MultiSearchRequest var1);

    public void multiSearch(MultiSearchRequest var1, ActionListener<MultiSearchResponse> var2);

    public MultiSearchRequestBuilder prepareMultiSearch();

    public ActionFuture<TermVectorsResponse> termVectors(TermVectorsRequest var1);

    public void termVectors(TermVectorsRequest var1, ActionListener<TermVectorsResponse> var2);

    public TermVectorsRequestBuilder prepareTermVectors();

    public TermVectorsRequestBuilder prepareTermVectors(String var1, String var2);

    public ActionFuture<MultiTermVectorsResponse> multiTermVectors(MultiTermVectorsRequest var1);

    public void multiTermVectors(MultiTermVectorsRequest var1, ActionListener<MultiTermVectorsResponse> var2);

    public MultiTermVectorsRequestBuilder prepareMultiTermVectors();

    public ExplainRequestBuilder prepareExplain(String var1, String var2);

    public ActionFuture<ExplainResponse> explain(ExplainRequest var1);

    public void explain(ExplainRequest var1, ActionListener<ExplainResponse> var2);

    public ClearScrollRequestBuilder prepareClearScroll();

    public ActionFuture<ClearScrollResponse> clearScroll(ClearScrollRequest var1);

    public void clearScroll(ClearScrollRequest var1, ActionListener<ClearScrollResponse> var2);

    public FieldCapabilitiesRequestBuilder prepareFieldCaps(String ... var1);

    public ActionFuture<FieldCapabilitiesResponse> fieldCaps(FieldCapabilitiesRequest var1);

    public void fieldCaps(FieldCapabilitiesRequest var1, ActionListener<FieldCapabilitiesResponse> var2);

    @Override
    public Settings settings();

    public Client filterWithHeader(Map<String, String> var1);

    public static User getUserContext(Client client) {
        String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        return User.parse(userStr);
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(CLIENT_TYPE_SETTING_S);
        }
    }
}

