/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.client.metadata.BulkDataObjectRequest;
import io.skylite.core.client.metadata.BulkDataObjectResponse;
import io.skylite.core.client.metadata.ClientInterface;
import io.skylite.core.client.metadata.DataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.GetDataObjectResponse;
import io.skylite.core.client.metadata.PutDataObjectRequest;
import io.skylite.core.client.metadata.PutDataObjectResponse;
import io.skylite.core.client.metadata.SearchDataObjectRequest;
import io.skylite.core.client.metadata.SearchDataObjectResponse;
import io.skylite.core.client.metadata.UpdateDataObjectRequest;
import io.skylite.core.client.metadata.UpdateDataObjectResponse;
import io.skylite.core.common.Strings;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public class MetadataClient {
    private final ClientInterface delegate;
    private final Executor defaultExecutor;
    private final boolean isMultiTenancyEnabled;

    public MetadataClient(ClientInterface delegate, boolean isMultiTenancyEnabled) {
        this(delegate, ForkJoinPool.commonPool(), isMultiTenancyEnabled);
    }

    public MetadataClient(ClientInterface delegate, Executor defaultExecutor, boolean isMultiTenancyEnabled) {
        this.delegate = delegate;
        this.defaultExecutor = defaultExecutor;
        this.isMultiTenancyEnabled = isMultiTenancyEnabled;
    }

    public CompletionStage<PutDataObjectResponse> putDataObjectAsync(PutDataObjectRequest request, Executor executor) {
        this.validateTenantId(request.tenantId());
        return this.delegate.putDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<PutDataObjectResponse> putDataObjectAsync(PutDataObjectRequest request) {
        return this.putDataObjectAsync(request, this.defaultExecutor);
    }

    public PutDataObjectResponse putDataObject(PutDataObjectRequest request) {
        try {
            return this.putDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw SkyliteExceptionsHelper.convertToRuntime(SkyliteExceptionsHelper.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<GetDataObjectResponse> getDataObjectAsync(GetDataObjectRequest request, Executor executor) {
        return this.delegate.getDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<GetDataObjectResponse> getDataObjectAsync(GetDataObjectRequest request) {
        this.validateTenantId(request.tenantId());
        return this.getDataObjectAsync(request, this.defaultExecutor);
    }

    public GetDataObjectResponse getDataObject(GetDataObjectRequest request) {
        try {
            return this.getDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw SkyliteExceptionsHelper.convertToRuntime(SkyliteExceptionsHelper.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<UpdateDataObjectResponse> updateDataObjectAsync(UpdateDataObjectRequest request, Executor executor) {
        this.validateTenantId(request.tenantId());
        return this.delegate.updateDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<UpdateDataObjectResponse> updateDataObjectAsync(UpdateDataObjectRequest request) {
        return this.updateDataObjectAsync(request, this.defaultExecutor);
    }

    public UpdateDataObjectResponse updateDataObject(UpdateDataObjectRequest request) {
        try {
            return this.updateDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw SkyliteExceptionsHelper.convertToRuntime(SkyliteExceptionsHelper.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<DeleteDataObjectResponse> deleteDataObjectAsync(DeleteDataObjectRequest request, Executor executor) {
        this.validateTenantId(request.tenantId());
        return this.delegate.deleteDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<DeleteDataObjectResponse> deleteDataObjectAsync(DeleteDataObjectRequest request) {
        return this.deleteDataObjectAsync(request, this.defaultExecutor);
    }

    public DeleteDataObjectResponse deleteDataObject(DeleteDataObjectRequest request) {
        try {
            return this.deleteDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw SkyliteExceptionsHelper.convertToRuntime(SkyliteExceptionsHelper.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<BulkDataObjectResponse> bulkDataObjectAsync(BulkDataObjectRequest request, Executor executor) {
        this.validateTenantIds(request.requests());
        return this.delegate.bulkDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<BulkDataObjectResponse> bulkDataObjectAsync(BulkDataObjectRequest request) {
        return this.bulkDataObjectAsync(request, this.defaultExecutor);
    }

    public BulkDataObjectResponse bulkDataObject(BulkDataObjectRequest request) {
        try {
            return this.bulkDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw SkyliteExceptionsHelper.convertToRuntime(SkyliteExceptionsHelper.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<SearchDataObjectResponse> searchDataObjectAsync(SearchDataObjectRequest request, Executor executor) {
        this.validateTenantId(request.tenantId());
        return this.delegate.searchDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<SearchDataObjectResponse> searchDataObjectAsync(SearchDataObjectRequest request) {
        return this.searchDataObjectAsync(request, this.defaultExecutor);
    }

    public SearchDataObjectResponse searchDataObject(SearchDataObjectRequest request) {
        try {
            return this.searchDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw SkyliteExceptionsHelper.convertToRuntime(SkyliteExceptionsHelper.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public ClientInterface getDelegate() {
        return this.delegate;
    }

    private void validateTenantId(String tenantId) {
        if (Boolean.TRUE.equals(this.isMultiTenancyEnabled) && Strings.isNullOrEmpty(tenantId)) {
            throw new IllegalArgumentException("A tenant ID is required when multitenancy is enabled.");
        }
    }

    private void validateTenantIds(List<DataObjectRequest> requests) {
        if (Boolean.TRUE.equals(this.isMultiTenancyEnabled) && requests.stream().map(DataObjectRequest::tenantId).anyMatch(Strings::isNullOrEmpty)) {
            throw new IllegalArgumentException("A tenant ID is required for every bulk request when multitenancy is enabled.");
        }
    }
}

