/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.common.TriFunction;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.client.metadata.ClientInterface;
import io.skylite.core.client.metadata.LocalClusterIndicesClient;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.common.Strings;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataClientFactory {
    private static final Logger log = LogManager.getLogger(MetadataClientFactory.class);
    private TriFunction<ReleasableSkyliteClient, NamedXContentRegistry, Map<String, String>, ClientInterface> defaultFactory;

    public static MetadataClient createSdkClient(ReleasableSkyliteClient client, NamedXContentRegistry xContentRegistry, Map<String, String> metadataSettings) {
        return MetadataClientFactory.createSdkClient(client, xContentRegistry, metadataSettings, ForkJoinPool.commonPool());
    }

    public static MetadataClient createSdkClient(ReleasableSkyliteClient client, NamedXContentRegistry xContentRegistry, Map<String, String> metadataSettings, Executor defaultExecutor) {
        String remoteMetadataType = metadataSettings.get("remote_metadata_type");
        Boolean multiTenancy = Boolean.parseBoolean(metadataSettings.get("tenant_aware"));
        ServiceLoader<ClientInterface> loader = ServiceLoader.load(ClientInterface.class);
        Iterator<ClientInterface> iterator = loader.iterator();
        if (Strings.isNullOrEmpty(remoteMetadataType)) {
            log.info("Using local lucenia cluster as metadata store.");
            return MetadataClientFactory.createDefaultClient(client, xContentRegistry, metadataSettings, defaultExecutor, multiTenancy);
        }
        while (iterator.hasNext()) {
            ClientInterface delegate = iterator.next();
            if (!delegate.supportsMetadataType(remoteMetadataType)) continue;
            log.info("Using {} as metadata store.", (Object)remoteMetadataType);
            delegate.initialize(metadataSettings);
            return new MetadataClient(delegate, defaultExecutor, multiTenancy);
        }
        log.warn("Unable to find {} client implementation. Using local lucenia cluster as metadata store.", (Object)remoteMetadataType);
        return MetadataClientFactory.createDefaultClient(client, xContentRegistry, metadataSettings, defaultExecutor, multiTenancy);
    }

    private static MetadataClient createDefaultClient(ReleasableSkyliteClient client, NamedXContentRegistry xContentRegistry, Map<String, String> metadataSettings, Executor defaultExecutor, Boolean multiTenancy) {
        LocalClusterIndicesClient defaultclient = new LocalClusterIndicesClient(client, xContentRegistry, metadataSettings);
        return new MetadataClient(defaultclient, defaultExecutor, multiTenancy);
    }

    static MetadataClient wrapSdkClientDelegate(ClientInterface delegate, Boolean multiTenancy) {
        return new MetadataClient(delegate, multiTenancy);
    }
}

