/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.core.search.builder.SearchSourceBuilder;

public class SearchDataObjectRequest {
    private final String[] indices;
    private final String tenantId;
    private final SearchSourceBuilder searchSourceBuilder;

    public SearchDataObjectRequest(String[] indices, String tenantId, SearchSourceBuilder searchSourceBuilder) {
        this.indices = indices;
        this.tenantId = tenantId;
        this.searchSourceBuilder = searchSourceBuilder;
    }

    public String[] indices() {
        return this.indices;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public SearchSourceBuilder searchSourceBuilder() {
        return this.searchSourceBuilder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String[] indices = null;
        private String tenantId = null;
        private SearchSourceBuilder searchSourceBuilder;

        private Builder() {
        }

        public Builder indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder searchSourceBuilder(SearchSourceBuilder searchSourceBuilder) {
            this.searchSourceBuilder = searchSourceBuilder;
            return this;
        }

        public SearchDataObjectRequest build() {
            return new SearchDataObjectRequest(this.indices, this.tenantId, this.searchSourceBuilder);
        }
    }
}

