/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.metadata;

import io.skylite.core.client.metadata.DataObjectRequest;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;

public class UpdateDataObjectRequest
extends DataObjectRequest {
    private final Long ifSeqNo;
    private final Long ifPrimaryTerm;
    private final int retryOnConflict;
    private final ToXContentObject dataObject;

    public UpdateDataObjectRequest(String index, String id, String tenantId, Long ifSeqNo, Long ifPrimaryTerm, int retryOnConflict, ToXContentObject dataObject) {
        super(index, id, tenantId);
        this.ifSeqNo = ifSeqNo;
        this.ifPrimaryTerm = ifPrimaryTerm;
        this.retryOnConflict = retryOnConflict;
        this.dataObject = dataObject;
    }

    public Long ifSeqNo() {
        return this.ifSeqNo;
    }

    public Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    public int retryOnConflict() {
        return this.retryOnConflict;
    }

    public ToXContentObject dataObject() {
        return this.dataObject;
    }

    @Override
    public boolean isWriteRequest() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DataObjectRequest.Builder<Builder> {
        private Long ifSeqNo = null;
        private Long ifPrimaryTerm = null;
        private int retryOnConflict = 0;
        private ToXContentObject dataObject = null;

        public Builder ifSeqNo(long seqNo) {
            if (seqNo < 0L && seqNo != -2L) {
                throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
            }
            this.ifSeqNo = seqNo;
            return this;
        }

        public Builder ifPrimaryTerm(long term) {
            if (term < 0L) {
                throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
            }
            this.ifPrimaryTerm = term;
            return this;
        }

        public Builder retryOnConflict(int retries) {
            this.retryOnConflict = retries;
            return this;
        }

        public Builder dataObject(ToXContentObject dataObject) {
            this.dataObject = dataObject;
            return this;
        }

        public Builder dataObject(final Map<String, Object> dataObjectMap) {
            this.dataObject = new ToXContentObject(){

                @Override
                public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                    return builder.map(dataObjectMap);
                }
            };
            return this;
        }

        public UpdateDataObjectRequest build() {
            if (this.ifSeqNo == null != (this.ifPrimaryTerm == null)) {
                throw new IllegalArgumentException("Either ifSeqNo and ifPrimaryTerm must both be null or both must be non-null.");
            }
            return new UpdateDataObjectRequest(this.index, this.id, this.tenantId, this.ifSeqNo, this.ifPrimaryTerm, this.retryOnConflict, this.dataObject);
        }
    }
}

