/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.client.node;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.BaseActionRegistry;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.support.AbstractClient;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskListener;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.RemoteClusterService;
import java.util.function.Supplier;

public class NodeClient
extends AbstractClient {
    private BaseActionRegistry actionRegistry;
    private Supplier<String> localNodeId;
    private RemoteClusterService remoteClusterService;
    private NamedWriteableRegistry namedWriteableRegistry;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(BaseActionRegistry actionRegistry, Supplier<String> localNodeId, RemoteClusterService remoteClusterService, NamedWriteableRegistry namedWriteableRegistry) {
        this.actionRegistry = actionRegistry;
        this.localNodeId = localNodeId;
        this.remoteClusterService = remoteClusterService;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    public void close() {
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.executeLocally(action, request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, TaskListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public String getLocalNodeId() {
        return this.localNodeId.get();
    }

    private <Request extends ActionRequest, Response extends ActionResponse> TransportAction<Request, Response> transportAction(ActionType<Response> action) {
        if (this.actionRegistry == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction<? extends ActionRequest, ? extends ActionResponse> transportAction = this.actionRegistry.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + String.valueOf(action) + "] to execute");
        }
        return transportAction;
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias);
    }

    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }
}

