/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster;

import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterName
implements Writeable {
    public static final Setting<ClusterName> CLUSTER_NAME_SETTING = new Setting<ClusterName>("cluster.name", "lucenia", s -> {
        if (s.isEmpty()) {
            throw new IllegalArgumentException("[cluster.name] must not be empty");
        }
        if (s.contains(":")) {
            throw new IllegalArgumentException("[cluster.name] must not contain ':'");
        }
        return new ClusterName((String)s);
    }, Setting.Property.NodeScope);
    public static final ClusterName DEFAULT = CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY);
    private final String value;

    public ClusterName(StreamInput input) throws IOException {
        this(input.readString());
    }

    @Inject
    public ClusterName(String value) {
        this.value = value.intern();
    }

    public String value() {
        return this.value;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterName that = (ClusterName)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Cluster [" + this.value + "]";
    }

    public Predicate<ClusterName> getEqualityPredicate() {
        return new Predicate<ClusterName>(){

            @Override
            public boolean test(ClusterName o) {
                return ClusterName.this.equals(o);
            }

            public String toString() {
                return "local cluster name [" + ClusterName.this.value() + "]";
            }
        };
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(CLUSTER_NAME_SETTING);
        }
    }
}

