/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.block;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.cluster.block.ClusterBlock;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClusterBlockException
extends SkyliteException {
    private final Set<ClusterBlock> blocks;

    public ClusterBlockException(Set<ClusterBlock> globalLevelBlocks) {
        super(ClusterBlockException.buildMessageForGlobalBlocks(globalLevelBlocks), new Object[0]);
        this.blocks = globalLevelBlocks;
    }

    public ClusterBlockException(Map<String, Set<ClusterBlock>> indexLevelBlocks) {
        super(ClusterBlockException.buildMessageForIndexBlocks(indexLevelBlocks), new Object[0]);
        this.blocks = indexLevelBlocks.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public ClusterBlockException(StreamInput in) throws IOException {
        super(in);
        this.blocks = Collections.unmodifiableSet(in.readSet(ClusterBlock::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.blocks != null) {
            out.writeCollection(this.blocks);
        } else {
            out.writeVInt(0);
        }
    }

    public boolean retryable() {
        for (ClusterBlock block : this.blocks) {
            if (block.retryable()) continue;
            return false;
        }
        return true;
    }

    public Set<ClusterBlock> blocks() {
        return this.blocks;
    }

    private static String buildMessageForGlobalBlocks(Set<ClusterBlock> globalLevelBlocks) {
        assert (!globalLevelBlocks.isEmpty());
        Function<ClusterBlock, String> blockDescription = block -> String.valueOf((Object)block.status()) + "/" + block.id() + "/" + block.description();
        StringBuilder sb = new StringBuilder();
        if (!globalLevelBlocks.isEmpty()) {
            sb.append("blocked by: [");
            sb.append(globalLevelBlocks.stream().map(blockDescription).collect(Collectors.joining(", ")));
            sb.append("];");
        }
        return sb.toString();
    }

    private static String buildMessageForIndexBlocks(Map<String, Set<ClusterBlock>> indexLevelBlocks) {
        assert (!indexLevelBlocks.isEmpty());
        Function<ClusterBlock, String> blockDescription = block -> String.valueOf((Object)block.status()) + "/" + block.id() + "/" + block.description();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<ClusterBlock>> entry : indexLevelBlocks.entrySet()) {
            sb.append("index [" + entry.getKey() + "] blocked by: [");
            sb.append(entry.getValue().stream().map(blockDescription).collect(Collectors.joining(", ")));
            sb.append("];");
        }
        return sb.toString();
    }

    @Override
    public RestStatus status() {
        RestStatus status = null;
        boolean onlyRetryableBlocks = true;
        for (ClusterBlock block : this.blocks) {
            boolean isRetryableBlock;
            boolean bl = isRetryableBlock = block.status() == RestStatus.TOO_MANY_REQUESTS;
            if (!isRetryableBlock) {
                if (status == null) {
                    status = block.status();
                } else if (status.getStatus() < block.status().getStatus()) {
                    status = block.status();
                }
            }
            onlyRetryableBlocks = onlyRetryableBlocks && isRetryableBlock;
        }
        if (onlyRetryableBlocks) {
            return RestStatus.TOO_MANY_REQUESTS;
        }
        return status;
    }

    public static class Registration
    implements SkyliteExceptionProvider<ClusterBlockException> {
        @Override
        public Class<ClusterBlockException> getExceptionClass() {
            return ClusterBlockException.class;
        }

        @Override
        public CheckedFunction<StreamInput, ClusterBlockException, IOException> getConstructor() {
            return ClusterBlockException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 49;
        }
    }
}

