/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.metadata;

import io.skylite.core.cluster.block.ClusterBlock;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.settings.Setting;
import java.io.IOException;

public enum IndexMetadataAPIBlock implements Writeable
{
    READ_ONLY("read_only", IndexMetadata.INDEX_READ_ONLY_BLOCK),
    READ("read", IndexMetadata.INDEX_READ_BLOCK),
    WRITE("write", IndexMetadata.INDEX_WRITE_BLOCK),
    METADATA("metadata", IndexMetadata.INDEX_METADATA_BLOCK),
    READ_ONLY_ALLOW_DELETE("read_only_allow_delete", IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK);

    final String name;
    final String settingName;
    final Setting<Boolean> setting;
    final ClusterBlock block;

    private IndexMetadataAPIBlock(String name, ClusterBlock block) {
        this.name = name;
        this.settingName = "index.blocks." + name;
        this.setting = Setting.boolSetting(this.settingName, false, Setting.Property.Dynamic, Setting.Property.IndexScope);
        this.block = block;
    }

    public String getName() {
        return this.name;
    }

    public String settingName() {
        return this.settingName;
    }

    public Setting<Boolean> setting() {
        return this.setting;
    }

    public ClusterBlock getBlock() {
        return this.block;
    }

    public static IndexMetadataAPIBlock fromName(String name) {
        for (IndexMetadataAPIBlock block : IndexMetadataAPIBlock.values()) {
            if (!block.name.equals(name)) continue;
            return block;
        }
        throw new IllegalArgumentException("No block found with name " + name);
    }

    public static IndexMetadataAPIBlock fromSetting(String settingName) {
        for (IndexMetadataAPIBlock block : IndexMetadataAPIBlock.values()) {
            if (!block.settingName.equals(settingName)) continue;
            return block;
        }
        throw new IllegalArgumentException("No block found with setting name " + settingName);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static IndexMetadataAPIBlock readFrom(StreamInput input) throws IOException {
        return IndexMetadataAPIBlock.values()[input.readVInt()];
    }
}

