/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.metadata;

import io.skylite.SkyliteParseException;
import io.skylite.core.common.AbstractDiffable;
import io.skylite.core.common.Diff;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.compress.CompressedXContent;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class MappingMetadata
extends AbstractDiffable<MappingMetadata> {
    public static final MappingMetadata EMPTY_MAPPINGS = new MappingMetadata("_doc", Collections.emptyMap());
    private final String type;
    private final CompressedXContent source;
    private final boolean routingRequired;

    public MappingMetadata(String type, CompressedXContent mappingSource, boolean routingRequired) {
        this.type = type;
        this.source = mappingSource;
        this.routingRequired = routingRequired;
    }

    public MappingMetadata(CompressedXContent mapping) {
        this.source = mapping;
        Map mappingMap = (Map)XContentHelper.convertToMap(mapping.compressedReference(), true).v2();
        if (mappingMap.size() != 1) {
            throw new IllegalStateException("Can't derive type from mapping, no root type: " + mapping.string());
        }
        this.type = (String)mappingMap.keySet().iterator().next();
        this.routingRequired = this.isRoutingRequired((Map)mappingMap.get(this.type));
    }

    public MappingMetadata(String type, Map<String, Object> mapping) {
        this.type = type;
        try {
            XContentBuilder mappingBuilder = MediaTypeRegistry.contentBuilder(MediaTypeRegistry.JSON).map(mapping);
            this.source = new CompressedXContent(BytesReference.bytes(mappingBuilder));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Map withoutType = mapping;
        if (mapping.size() == 1 && mapping.containsKey(type)) {
            withoutType = (Map)mapping.get(type);
        }
        this.routingRequired = this.isRoutingRequired(withoutType);
    }

    private boolean isRoutingRequired(Map<String, Object> withoutType) {
        boolean required = false;
        if (withoutType.containsKey("_routing")) {
            Map routingNode = (Map)withoutType.get("_routing");
            for (Map.Entry entry : routingNode.entrySet()) {
                String fieldName = (String)entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("required")) continue;
                try {
                    required = XContentMapValuesUtil.nodeBooleanValue(fieldNode);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("Failed to create mapping for type [" + this.type() + "]. Illegal value in field [_routing.required].", ex);
                }
            }
        }
        return required;
    }

    public String type() {
        return this.type;
    }

    public CompressedXContent source() {
        return this.source;
    }

    public Map<String, Object> sourceAsMap() throws SkyliteParseException {
        Map mapping = (Map)XContentHelper.convertToMap(this.source.compressedReference(), true).v2();
        if (mapping.size() == 1 && mapping.containsKey(this.type())) {
            mapping = (Map)mapping.get(this.type());
        }
        return mapping;
    }

    public Map<String, Object> getSourceAsMap() throws SkyliteParseException {
        return this.sourceAsMap();
    }

    public boolean routingRequired() {
        return this.routingRequired;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type());
        this.source().writeTo(out);
        out.writeBoolean(this.routingRequired);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingMetadata that = (MappingMetadata)o;
        if (!Objects.equals(this.routingRequired, that.routingRequired)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.source, this.routingRequired);
    }

    public MappingMetadata(StreamInput in) throws IOException {
        this.type = in.readString();
        this.source = CompressedXContent.readCompressedString(in);
        this.routingRequired = in.readBoolean();
    }

    public static Diff<MappingMetadata> readDiffFrom(StreamInput in) throws IOException {
        return MappingMetadata.readDiffFrom(MappingMetadata::new, in);
    }
}

