/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.metadata;

import io.skylite.common.Nullable;
import io.skylite.core.cluster.metadata.ComponentTemplate;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexTemplateMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.Template;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.settings.Settings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.util.CollectionUtil;

public class MetadataIndexTemplateUtility {
    @Nullable
    public static String findV2Template(Metadata metadata, String indexName, boolean isHidden) {
        Predicate<String> patternMatchPredicate = pattern -> Regex.simpleMatch(pattern, indexName);
        HashMap<ComposableIndexTemplate, String> matchedTemplates = new HashMap<ComposableIndexTemplate, String>();
        for (Map.Entry<String, ComposableIndexTemplate> entry : metadata.templatesV2().entrySet()) {
            String name = entry.getKey();
            ComposableIndexTemplate template = entry.getValue();
            if (!isHidden) {
                boolean matched = template.indexPatterns().stream().anyMatch(patternMatchPredicate);
                if (!matched) continue;
                matchedTemplates.put(template, name);
                continue;
            }
            boolean isNotMatchAllTemplate = template.indexPatterns().stream().noneMatch(Regex::isMatchAllPattern);
            if (!isNotMatchAllTemplate || !template.indexPatterns().stream().anyMatch(patternMatchPredicate)) continue;
            matchedTemplates.put(template, name);
        }
        if (matchedTemplates.size() == 0) {
            return null;
        }
        ArrayList candidates = new ArrayList(matchedTemplates.keySet());
        CollectionUtil.timSort(candidates, Comparator.comparing(ComposableIndexTemplate::priorityOrZero, Comparator.reverseOrder()));
        assert (candidates.size() > 0) : "we should have returned early with no candidates";
        ComposableIndexTemplate winner = (ComposableIndexTemplate)candidates.get(0);
        String winnerName = (String)matchedTemplates.get(winner);
        if (winner.indexPatterns().stream().anyMatch(Regex::isMatchAllPattern) && IndexMetadata.INDEX_HIDDEN_SETTING.exists(MetadataIndexTemplateUtility.resolveSettings(metadata, winnerName))) {
            throw new IllegalStateException("global index template [" + winnerName + "], composed of component templates [" + String.join((CharSequence)",", winner.composedOf()) + "] defined the index.hidden setting, which is not allowed");
        }
        return winnerName;
    }

    public static Settings resolveSettings(Metadata metadata, String templateName) {
        ComposableIndexTemplate template = metadata.templatesV2().get(templateName);
        assert (template != null) : "attempted to resolve settings for a template [" + templateName + "] that did not exist in the cluster state";
        if (template == null) {
            return Settings.EMPTY;
        }
        return MetadataIndexTemplateUtility.resolveSettings(metadata, template);
    }

    public static Settings resolveSettings(Metadata metadata, ComposableIndexTemplate template) {
        Map<String, ComponentTemplate> componentTemplates = metadata.componentTemplates();
        List<Settings> componentSettings = template.composedOf().stream().map(componentTemplates::get).filter(Objects::nonNull).map(ComponentTemplate::template).map(Template::settings).filter(Objects::nonNull).collect(Collectors.toList());
        Settings.Builder templateSettings = Settings.builder();
        componentSettings.forEach(templateSettings::put);
        Optional.ofNullable(template.template()).map(Template::settings).ifPresent(templateSettings::put);
        return templateSettings.build();
    }

    public static List<IndexTemplateMetadata> findV1Templates(Metadata metadata, String indexName, @Nullable Boolean isHidden) {
        Optional<IndexTemplateMetadata> templateWithHiddenSetting;
        Predicate<String> patternMatchPredicate = pattern -> Regex.simpleMatch(pattern, indexName);
        ArrayList<IndexTemplateMetadata> matchedTemplates = new ArrayList<IndexTemplateMetadata>();
        for (IndexTemplateMetadata template2 : metadata.templates().values()) {
            if (isHidden == null || isHidden == Boolean.FALSE) {
                boolean matched = template2.patterns().stream().anyMatch(patternMatchPredicate);
                if (!matched) continue;
                matchedTemplates.add(template2);
                continue;
            }
            assert (isHidden == Boolean.TRUE);
            boolean isNotMatchAllTemplate = template2.patterns().stream().noneMatch(Regex::isMatchAllPattern);
            if (!isNotMatchAllTemplate || !template2.patterns().stream().anyMatch(patternMatchPredicate)) continue;
            matchedTemplates.add(template2);
        }
        CollectionUtil.timSort(matchedTemplates, Comparator.comparingInt(IndexTemplateMetadata::order).reversed());
        if (isHidden == null && (templateWithHiddenSetting = matchedTemplates.stream().filter(template -> IndexMetadata.INDEX_HIDDEN_SETTING.exists(template.settings())).findFirst()).isPresent()) {
            Optional<IndexTemplateMetadata> templateWithHiddenSettingPostRemoval;
            boolean templatedIsHidden = IndexMetadata.INDEX_HIDDEN_SETTING.get(templateWithHiddenSetting.get().settings());
            if (templatedIsHidden) {
                matchedTemplates.removeIf(current -> current.patterns().stream().anyMatch(Regex::isMatchAllPattern));
            }
            if (!(templateWithHiddenSettingPostRemoval = matchedTemplates.stream().filter(template -> IndexMetadata.INDEX_HIDDEN_SETTING.exists(template.settings())).findFirst()).isPresent() || templateWithHiddenSetting.get() != templateWithHiddenSettingPostRemoval.get()) {
                throw new IllegalStateException("A global index template [" + templateWithHiddenSetting.get().name() + "] defined the index hidden setting, which is not allowed");
            }
        }
        return Collections.unmodifiableList(matchedTemplates);
    }
}

