/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.node;

import io.skylite.common.Nullable;
import io.skylite.common.network.InetAddresses;
import io.skylite.common.network.NetworkAddress;
import io.skylite.core.ParseField;
import io.skylite.core.cluster.node.NodeInfo;
import io.skylite.core.common.Strings;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.common.transport.TransportAddress;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class DiscoveryNodeFilters {
    public static final BiConsumer<String, String> IP_VALIDATOR = (propertyKey, rawValue) -> {
        if (rawValue != null && (propertyKey.endsWith("._ip") || propertyKey.endsWith("._host_ip") || propertyKey.endsWith("_publish_ip"))) {
            for (String value : Strings.tokenizeToStringArray(rawValue, ",")) {
                if (Regex.isSimpleMatchPattern(value) || InetAddresses.isInetAddress((String)value)) continue;
                throw new IllegalArgumentException("invalid IP address [" + value + "] for [" + propertyKey + "]");
            }
        }
    };
    private final Map<String, String[]> filters;
    private final OpType opType;

    @Nullable
    public static DiscoveryNodeFilters buildOrUpdateFromKeyValue(DiscoveryNodeFilters original, OpType opType, Map<String, String> filters) {
        DiscoveryNodeFilters updated;
        if (original == null) {
            updated = new DiscoveryNodeFilters(opType, new HashMap<String, String[]>());
        } else {
            assert (opType == original.opType) : "operation type should match with node filter parameter";
            updated = new DiscoveryNodeFilters(original.opType, original.filters);
        }
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            String[] values = Strings.tokenizeToStringArray(entry.getValue(), ",");
            updated.filters.compute(entry.getKey(), (k, v) -> values.length > 0 ? values : null);
        }
        if (updated.filters.isEmpty()) {
            return null;
        }
        return updated;
    }

    DiscoveryNodeFilters(OpType opType, Map<String, String[]> filters) {
        this.opType = opType;
        this.filters = filters;
    }

    private boolean matchByIP(String[] values, @Nullable String hostIp, @Nullable String publishIp) {
        for (String value : values) {
            boolean matchIp;
            boolean bl = matchIp = Regex.simpleMatch(value, hostIp) || Regex.simpleMatch(value, publishIp);
            if (!matchIp) continue;
            return matchIp;
        }
        return false;
    }

    @Nullable
    public static DiscoveryNodeFilters trimTier(@Nullable DiscoveryNodeFilters original) {
        if (original == null) {
            return null;
        }
        Map<String, String[]> newFilters = original.filters.entrySet().stream().filter(entry -> {
            String attr = (String)entry.getKey();
            return attr != null && !attr.startsWith("_tier");
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (newFilters.size() == 0) {
            return null;
        }
        return new DiscoveryNodeFilters(original.opType, newFilters);
    }

    public boolean match(NodeInfo node) {
        for (Map.Entry<String, String[]> entry : this.filters.entrySet()) {
            int n;
            String attr = entry.getKey();
            String[] values = entry.getValue();
            if ("_ip".equals(attr)) {
                String publishAddress = null;
                if (node.getAddress() instanceof TransportAddress) {
                    publishAddress = NetworkAddress.format((InetAddress)node.getAddress().address().getAddress());
                }
                boolean match = this.matchByIP(values, node.getHostAddress(), publishAddress);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_host_ip".equals(attr)) {
                boolean match = this.matchByIP(values, node.getHostAddress(), null);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_publish_ip".equals(attr)) {
                String address = null;
                if (node.getAddress() instanceof TransportAddress) {
                    address = NetworkAddress.format((InetAddress)node.getAddress().address().getAddress());
                }
                boolean match = this.matchByIP(values, address, null);
                if (this.opType == OpType.AND) {
                    if (match) continue;
                    return false;
                }
                if (!match || this.opType != OpType.OR) continue;
                return true;
            }
            if ("_host".equals(attr)) {
                String[] address = values;
                int n2 = address.length;
                for (n = 0; n < n2; ++n) {
                    String value = address[n];
                    if (Regex.simpleMatch(value, node.getHostName()) || Regex.simpleMatch(value, node.getHostAddress())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_id".equals(attr)) {
                String[] address = values;
                int n3 = address.length;
                for (n = 0; n < n3; ++n) {
                    String value = address[n];
                    if (node.getId().equals(value)) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if (ParseField.CommonMetaFields.NAME_FIELD.getPreferredName().equals(attr) || "name".equals(attr)) {
                String[] address = values;
                int n4 = address.length;
                for (n = 0; n < n4; ++n) {
                    String value = address[n];
                    if (Regex.simpleMatch(value, node.getName())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            String nodeAttributeValue = node.getAttributes().get(attr);
            if (nodeAttributeValue == null) {
                if (this.opType != OpType.AND) continue;
                return false;
            }
            String[] stringArray = values;
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String value = stringArray[i];
                if (Regex.simpleMatch(value, nodeAttributeValue)) {
                    if (this.opType != OpType.OR) continue;
                    return true;
                }
                if (this.opType != OpType.AND) continue;
                return false;
            }
        }
        return this.opType != OpType.OR;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int entryCount = this.filters.size();
        for (Map.Entry<String, String[]> entry : this.filters.entrySet()) {
            String attr = entry.getKey();
            String[] values = entry.getValue();
            sb.append(attr);
            sb.append(":\"");
            int valueCount = values.length;
            for (String value : values) {
                sb.append(value);
                if (valueCount > 1) {
                    sb.append(" ").append(this.opType.toString()).append(" ");
                }
                --valueCount;
            }
            sb.append("\"");
            if (entryCount > 1) {
                sb.append(",");
            }
            --entryCount;
        }
        return sb.toString();
    }

    public static enum OpType {
        AND,
        OR;

    }
}

