/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.node;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public final class NodeInfo
implements Writeable {
    private final String nodeName;
    private final String nodeId;
    private final String ephemeralId;
    private final String hostName;
    private final String hostAddress;
    private final TransportAddress address;
    private final Map<String, String> attributes;
    private final Version version;

    public NodeInfo(String nodeName, String nodeId, String ephemeralId, String hostName, String hostAddress, TransportAddress address, Map<String, String> attributes, Version version) {
        this.nodeName = nodeName != null ? nodeName.intern() : "";
        this.nodeId = nodeId.intern();
        this.ephemeralId = ephemeralId.intern();
        this.hostName = hostName.intern();
        this.hostAddress = hostAddress.intern();
        this.address = address;
        this.version = version == null ? Version.CURRENT : version;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public String getName() {
        return this.nodeName;
    }

    public String getId() {
        return this.nodeId;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public TransportAddress getAddress() {
        return this.address;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.nodeId);
        out.writeString(this.ephemeralId);
        out.writeString(this.hostName);
        out.writeString(this.hostAddress);
        this.address.writeTo(out);
        out.writeVInt(this.attributes.size());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
    }

    public static XContentBuilder toXContent(NodeInfo nodeInfo, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(nodeInfo.getId());
        builder.field("name", nodeInfo.getName());
        builder.field("ephemeral_id", nodeInfo.getEphemeralId());
        builder.field("transport_address", nodeInfo.getAddress().toString());
        builder.startObject("attributes");
        for (Map.Entry<String, String> entry : nodeInfo.getAttributes().entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo that = (NodeInfo)o;
        return this.ephemeralId.equals(that.ephemeralId);
    }

    public int hashCode() {
        return this.ephemeralId.hashCode();
    }
}

