/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing;

import io.skylite.SkyliteException;
import io.skylite.core.action.search.SearchShardIterator;
import io.skylite.core.cluster.routing.OperationRouting;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.routing.WeightedRoutingStats;
import io.skylite.core.cluster.routing.WeightedRoutingUtils;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchShardTarget;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class FailAwareWeightedRouting {
    public static final FailAwareWeightedRouting INSTANCE = new FailAwareWeightedRouting();
    private static final Logger logger = LogManager.getLogger(FailAwareWeightedRouting.class);
    private static final List<RestStatus> internalErrorRestStatusList = List.of(RestStatus.INTERNAL_SERVER_ERROR, RestStatus.BAD_GATEWAY, RestStatus.SERVICE_UNAVAILABLE, RestStatus.GATEWAY_TIMEOUT);

    public static FailAwareWeightedRouting getInstance() {
        return INSTANCE;
    }

    private boolean isInternalFailure(Exception exception) {
        if (exception instanceof SkyliteException) {
            return internalErrorRestStatusList.contains((Object)((SkyliteException)exception).status());
        }
        return false;
    }

    public SearchShardTarget findNext(SearchShardIterator shardIt, ClusterState clusterState, Exception exception, Runnable onShardSkipped) {
        SearchShardTarget next = shardIt.nextOrNull();
        if (this.ignoreWeightedRouting(clusterState)) {
            return next;
        }
        while (next != null && WeightedRoutingUtils.isWeighedAway(next.getNodeId(), clusterState)) {
            SearchShardTarget nextShard = next;
            if (this.canFailOpen(nextShard.getShardId(), shardIt.size(), exception, clusterState)) {
                logger.info(() -> new ParameterizedMessage("{}: Fail open executed due to exception", (Object)nextShard.getShardId()), (Throwable)exception);
                this.getWeightedRoutingStats().updateFailOpenCount();
                break;
            }
            next = shardIt.nextOrNull();
            onShardSkipped.run();
        }
        return next;
    }

    public ShardRouting findNext(ShardsIterator shardsIt, ClusterState clusterState, Exception exception, Runnable onShardSkipped) {
        ShardRouting next = shardsIt.nextOrNull();
        if (this.ignoreWeightedRouting(clusterState)) {
            return next;
        }
        while (next != null && WeightedRoutingUtils.isWeighedAway(next.currentNodeId(), clusterState)) {
            ShardRouting nextShard = next;
            if (this.canFailOpen(nextShard.shardId(), shardsIt.size(), exception, clusterState)) {
                logger.info(() -> new ParameterizedMessage("{}: Fail open executed due to exception", (Object)nextShard.shardId()), (Throwable)exception);
                this.getWeightedRoutingStats().updateFailOpenCount();
                break;
            }
            next = shardsIt.nextOrNull();
            onShardSkipped.run();
        }
        return next;
    }

    private boolean canFailOpen(ShardId shardId, int shardItSize, Exception exception, ClusterState clusterState) {
        return shardItSize == 1 || this.isInternalFailure(exception) || this.hasInActiveShardCopies(clusterState, shardId);
    }

    private boolean hasInActiveShardCopies(ClusterState clusterState, ShardId shardId) {
        List<ShardRouting> shards = clusterState.routingTable().shardRoutingTable(shardId).shards();
        for (ShardRouting shardRouting : shards) {
            if (shardRouting.active()) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreWeightedRouting(ClusterState clusterState) {
        return OperationRouting.IGNORE_WEIGHTED_SHARD_ROUTING.get(clusterState.getMetadata().settings());
    }

    public WeightedRoutingStats getWeightedRoutingStats() {
        return WeightedRoutingStats.getInstance();
    }
}

