/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.cluster.routing.RoutingException;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class IllegalShardRoutingStateException
extends RoutingException {
    private final ShardRouting shard;

    public IllegalShardRoutingStateException(ShardRouting shard, String message) {
        this(shard, message, null);
    }

    public IllegalShardRoutingStateException(ShardRouting shard, String message, Throwable cause) {
        super(shard.shortSummary() + ": " + message, cause);
        this.shard = shard;
    }

    public IllegalShardRoutingStateException(StreamInput in) throws IOException {
        super(in);
        this.shard = new ShardRouting(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shard.writeTo(out);
    }

    public ShardRouting shard() {
        return this.shard;
    }

    public static class Registration
    implements SkyliteExceptionProvider<IllegalShardRoutingStateException> {
        @Override
        public Class<IllegalShardRoutingStateException> getExceptionClass() {
            return IllegalShardRoutingStateException.class;
        }

        @Override
        public CheckedFunction<StreamInput, IllegalShardRoutingStateException, IOException> getConstructor() {
            return IllegalShardRoutingStateException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 17;
        }
    }
}

