/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing;

import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.UnassignedInfo;

public interface RoutingChangesObserver {
    public void shardInitialized(ShardRouting var1, ShardRouting var2);

    public void shardStarted(ShardRouting var1, ShardRouting var2);

    public void relocationStarted(ShardRouting var1, ShardRouting var2);

    public void unassignedInfoUpdated(ShardRouting var1, UnassignedInfo var2);

    public void shardFailed(ShardRouting var1, UnassignedInfo var2);

    public void relocationCompleted(ShardRouting var1);

    public void relocationSourceRemoved(ShardRouting var1);

    public void replicaPromoted(ShardRouting var1);

    public void initializedReplicaReinitialized(ShardRouting var1, ShardRouting var2);

    public static class DelegatingRoutingChangesObserver
    implements RoutingChangesObserver {
        private final RoutingChangesObserver[] routingChangesObservers;

        public DelegatingRoutingChangesObserver(RoutingChangesObserver ... routingChangesObservers) {
            this.routingChangesObservers = routingChangesObservers;
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.shardInitialized(unassignedShard, initializedShard);
            }
        }

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.shardStarted(initializingShard, startedShard);
            }
        }

        @Override
        public void relocationStarted(ShardRouting startedShard, ShardRouting targetRelocatingShard) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.relocationStarted(startedShard, targetRelocatingShard);
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.unassignedInfoUpdated(unassignedShard, newUnassignedInfo);
            }
        }

        @Override
        public void shardFailed(ShardRouting activeShard, UnassignedInfo unassignedInfo) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.shardFailed(activeShard, unassignedInfo);
            }
        }

        @Override
        public void relocationCompleted(ShardRouting removedRelocationSource) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.relocationCompleted(removedRelocationSource);
            }
        }

        @Override
        public void relocationSourceRemoved(ShardRouting removedReplicaRelocationSource) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.relocationSourceRemoved(removedReplicaRelocationSource);
            }
        }

        @Override
        public void replicaPromoted(ShardRouting replicaShard) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.replicaPromoted(replicaShard);
            }
        }

        @Override
        public void initializedReplicaReinitialized(ShardRouting oldReplica, ShardRouting reinitializedReplica) {
            for (RoutingChangesObserver routingChangesObserver : this.routingChangesObservers) {
                routingChangesObserver.initializedReplicaReinitialized(oldReplica, reinitializedReplica);
            }
        }
    }

    public static class AbstractRoutingChangesObserver
    implements RoutingChangesObserver {
        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
        }

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
        }

        @Override
        public void relocationStarted(ShardRouting startedShard, ShardRouting targetRelocatingShard) {
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
        }

        @Override
        public void shardFailed(ShardRouting activeShard, UnassignedInfo unassignedInfo) {
        }

        @Override
        public void relocationCompleted(ShardRouting removedRelocationSource) {
        }

        @Override
        public void relocationSourceRemoved(ShardRouting removedReplicaRelocationSource) {
        }

        @Override
        public void replicaPromoted(ShardRouting replicaShard) {
        }

        @Override
        public void initializedReplicaReinitialized(ShardRouting oldReplica, ShardRouting reinitializedReplica) {
        }
    }
}

