/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing;

import java.util.ArrayList;
import java.util.List;

public class WeightedRoundRobin<T> {
    private List<Entity<T>> entities;

    public WeightedRoundRobin(List<Entity<T>> entities) {
        this.entities = entities;
    }

    public List<Entity<T>> orderEntities() {
        int lastSelectedEntity = -1;
        int size = this.entities.size();
        double currentWeight = 0.0;
        ArrayList<Entity<T>> orderedWeight = new ArrayList<Entity<T>>();
        if (size == 0) {
            return null;
        }
        double maxWeight = 0.0;
        double sumWeight = 0.0;
        Double gcd = null;
        for (Entity<T> entity : this.entities) {
            maxWeight = Math.max(maxWeight, entity.getWeight());
            gcd = gcd == null ? entity.getWeight() : this.gcd(gcd, entity.getWeight());
            sumWeight += entity.getWeight() > 0.0 ? entity.getWeight() : 0.0;
        }
        int count = 0;
        while ((double)count < sumWeight) {
            if ((lastSelectedEntity = (lastSelectedEntity + 1) % size) == 0 && (currentWeight -= gcd.doubleValue()) <= 0.0 && (currentWeight = maxWeight) == 0.0) {
                return orderedWeight;
            }
            if (!(this.entities.get(lastSelectedEntity).getWeight() >= currentWeight)) continue;
            orderedWeight.add(this.entities.get(lastSelectedEntity));
            ++count;
        }
        return orderedWeight;
    }

    private double gcd(double a, double b) {
        return b == 0.0 ? a : this.gcd(b, a % b);
    }

    static final class Entity<T> {
        private double weight;
        private T target;

        public Entity(double weight, T target) {
            this.weight = weight;
            this.target = target;
        }

        public T getTarget() {
            return this.target;
        }

        public void setTarget(T target) {
            this.target = target;
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }
    }
}

