/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing.allocation;

import io.skylite.core.cluster.routing.allocation.RerouteExplanation;
import io.skylite.core.cluster.routing.allocation.decider.Decision;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class RoutingExplanations
implements ToXContentFragment {
    private final List<RerouteExplanation> explanations = new ArrayList<RerouteExplanation>();

    public RoutingExplanations add(RerouteExplanation explanation) {
        this.explanations.add(explanation);
        return this;
    }

    public List<RerouteExplanation> explanations() {
        return this.explanations;
    }

    public List<String> getYesDecisionMessages() {
        return this.explanations().stream().filter(explanation -> explanation.decisions().type().equals(Decision.Type.YES)).map(explanation -> explanation.command().getMessage()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static RoutingExplanations readFrom(StreamInput in) throws IOException {
        int exCount = in.readVInt();
        RoutingExplanations exp = new RoutingExplanations();
        for (int i = 0; i < exCount; ++i) {
            RerouteExplanation explanation = RerouteExplanation.readFrom(in);
            exp.add(explanation);
        }
        return exp;
    }

    public static void writeTo(RoutingExplanations explanations, StreamOutput out) throws IOException {
        out.writeVInt(explanations.explanations.size());
        for (RerouteExplanation explanation : explanations.explanations) {
            RerouteExplanation.writeTo(explanation, out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("explanations");
        for (RerouteExplanation explanation : this.explanations) {
            explanation.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

