/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.routing.allocation.decider;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RoutingNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.decider.Decision;

public abstract class AllocationDecider {
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canRebalance(RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + String.valueOf(shardRouting);
        assert (shardRouting.unassigned()) : "must not call canForceAllocatePrimary on an assigned shard " + String.valueOf(shardRouting);
        Decision decision = this.canAllocate(shardRouting, node, allocation);
        if (decision.type() == Decision.Type.NO) {
            return allocation.decision(Decision.YES, decision.label(), "primary shard [%s] allowed to force allocate on node [%s]", shardRouting.shardId(), node.nodeId());
        }
        return decision;
    }

    public Decision canMoveAway(ShardRouting shardRouting, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canMoveAnyShard(RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocateAnyShardToNode(RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }
}

