/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.cluster.state;

import io.skylite.common.Nullable;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.Priority;

public interface ClusterStateTaskConfig {
    @Nullable
    public TimeValue timeout();

    public Priority priority();

    public static ClusterStateTaskConfig build(Priority priority) {
        return new Basic(priority, null);
    }

    public static ClusterStateTaskConfig build(Priority priority, TimeValue timeout) {
        return new Basic(priority, timeout);
    }

    public static class Basic
    implements ClusterStateTaskConfig {
        final TimeValue timeout;
        final Priority priority;

        public Basic(Priority priority, TimeValue timeout) {
            this.timeout = timeout;
            this.priority = priority;
        }

        @Override
        public TimeValue timeout() {
            return this.timeout;
        }

        @Override
        public Priority priority() {
            return this.priority;
        }
    }
}

