/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common;

import io.skylite.common.Nullable;
import io.skylite.core.common.Diff;
import io.skylite.core.common.Diffable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;

public abstract class AbstractDiffable<T extends Diffable<T>>
implements Diffable<T> {
    private static final Diff<?> EMPTY = new CompleteDiff();

    @Override
    public Diff<T> diff(T previousState) {
        if (this.equals(previousState)) {
            return EMPTY;
        }
        return new CompleteDiff<AbstractDiffable>(this);
    }

    public static <T extends Diffable<T>> Diff<T> readDiffFrom(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        if (in.readBoolean()) {
            return new CompleteDiff<Diffable>((Diffable)reader.read(in));
        }
        return EMPTY;
    }

    private static class CompleteDiff<T extends Diffable<T>>
    implements Diff<T> {
        @Nullable
        private final T part;

        CompleteDiff(T part) {
            this.part = part;
        }

        CompleteDiff() {
            this.part = null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.part != null) {
                out.writeBoolean(true);
                this.part.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public T apply(T part) {
            if (this.part != null) {
                return this.part;
            }
            return part;
        }
    }
}

