/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.skylite.SkyliteException;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.util.set.Sets;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRefBuilder;

public class Strings {
    static Logger log = LogManager.getLogger(Strings.class);
    public static final String UNKNOWN_UUID_VALUE = "_na_";
    public static final String EMPTY = "";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final Set<Character> INVALID_FILENAME_CHARS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Character[]{Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf(' '), Character.valueOf(',')}));
    public static final String TO_STRING_FUNCTION_NAME = ".toString()";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String DEFAULT_ESCAPE_FUNCTION = "\n    String escape(def input) { \n      if (input.contains(\"\\\\\")) {\n        input = input.replace(\"\\\\\", \"\\\\\\\\\");\n      }\n      if (input.contains(\"\\\"\")) {\n        input = input.replace(\"\\\"\", \"\\\\\\\"\");\n      }\n      if (input.contains('\r')) {\n        input = input = input.replace('\r', '\\\\r');\n      }\n      if (input.contains(\"\\\\t\")) {\n        input = input.replace(\"\\\\t\", \"\\\\\\\\\\\\t\");\n      }\n      if (input.contains('\n')) {\n        input = input.replace('\n', '\\\\n');\n      }\n      if (input.contains('\b')) {\n        input = input.replace('\b', '\\\\b');\n      }\n      if (input.contains('\f')) {\n        input = input.replace('\f', '\\\\f');\n      }\n      return input;\n    }\n";

    private Strings() {
    }

    public static void spaceify(int spaces, String from, StringBuilder to) throws Exception {
        try (BufferedReader reader = new BufferedReader(new StringReader(from));){
            String line;
            while ((line = reader.readLine()) != null) {
                for (int i = 0; i < spaces; ++i) {
                    to.append(' ');
                }
                to.append(line).append('\n');
            }
        }
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(BytesReference bytesReference) {
        return bytesReference != null && bytesReference.length() > 0;
    }

    public static boolean hasLength(String str) {
        return Strings.hasLength((CharSequence)str);
    }

    public static boolean isEmpty(CharSequence str) {
        return !Strings.hasLength(str);
    }

    public static boolean hasText(CharSequence str) {
        if (!Strings.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return Strings.hasText((CharSequence)str);
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!Strings.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString, pos, index);
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return Strings.replace(inString, pattern, EMPTY);
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String quote(String str) {
        return str != null ? "'" + str + "'" : null;
    }

    public static String capitalize(String str) {
        return Strings.changeFirstCharacterCase(str, true);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        if (capitalize) {
            sb.append(Character.toUpperCase(str.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str.charAt(0)));
        }
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static boolean validFileName(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean validFileNameExcludingAstrix(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '*' || !INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[0]);
    }

    public static String[] concatStringArrays(String[] first, String[] second) {
        if (first == null && second == null) {
            return EMPTY_ARRAY;
        }
        if (first == null || first.length == 0) {
            return second;
        }
        if (second == null || second.length == 0) {
            return first;
        }
        String[] concat = new String[first.length + second.length];
        System.arraycopy(first, 0, concat, 0, first.length);
        System.arraycopy(second, 0, concat, first.length, second.length);
        return concat;
    }

    public static Set<String> tokenizeByCommaToSet(String s) {
        if (s == null) {
            return Collections.emptySet();
        }
        return Strings.tokenizeToCollection(s, ",", HashSet::new);
    }

    public static String[] splitStringByCommaToArray(String s) {
        if (s == null || s.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return s.split(",");
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!Strings.hasLength(toSplit) || !Strings.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String[] tokenizeToStringArray(String s, String delimiters) {
        if (s == null) {
            return EMPTY_ARRAY;
        }
        return Strings.toStringArray(Strings.tokenizeToCollection(s, delimiters, ArrayList::new));
    }

    private static <T extends Collection<String>> T tokenizeToCollection(String s, String delimiters, Supplier<T> supplier) {
        if (s == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        Collection tokens = (Collection)supplier.get();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return (T)tokens;
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return EMPTY_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (EMPTY.equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(Strings.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(Strings.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(Strings.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return Strings.toStringArray(result);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return Strings.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return Strings.delimitedListToStringArray(str, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        TreeSet<String> set = new TreeSet<String>();
        String[] tokens = Strings.commaDelimitedListToStringArray(str);
        set.addAll(Arrays.asList(tokens));
        return set;
    }

    public static String collectionToDelimitedString(Iterable<?> coll, String delim, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        Strings.collectionToDelimitedString(coll, delim, prefix, suffix, sb);
        return sb.toString();
    }

    public static void collectionToDelimitedString(Iterable<?> coll, String delim, String prefix, String suffix, StringBuilder sb) {
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
    }

    public static String collectionToDelimitedString(Iterable<?> coll, String delim) {
        return Strings.collectionToDelimitedString(coll, delim, EMPTY, EMPTY);
    }

    public static String collectionToCommaDelimitedString(Iterable<?> coll) {
        return Strings.collectionToDelimitedString(coll, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        StringBuilder sb = new StringBuilder();
        Strings.arrayToDelimitedString(arr, delim, sb);
        return sb.toString();
    }

    public static void arrayToDelimitedString(Object[] arr, String delim, StringBuilder sb) {
        if (Strings.isEmpty(arr)) {
            return;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return Strings.arrayToDelimitedString(arr, ",");
    }

    public static String format1Decimals(double value, String suffix) {
        String p = String.valueOf(value);
        int ix = p.indexOf(46) + 1;
        int ex = p.indexOf(69);
        char fraction = p.charAt(ix);
        if (fraction == '0') {
            if (ex != -1) {
                return p.substring(0, ix - 1) + p.substring(ex) + suffix;
            }
            return p.substring(0, ix - 1) + suffix;
        }
        if (ex != -1) {
            return p.substring(0, ix) + fraction + p.substring(ex) + suffix;
        }
        return p.substring(0, ix) + fraction + suffix;
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static byte[] toUTF8Bytes(CharSequence charSequence) {
        return Strings.toUTF8Bytes(charSequence, new BytesRefBuilder());
    }

    public static byte[] toUTF8Bytes(CharSequence charSequence, BytesRefBuilder spare) {
        spare.copyChars(charSequence);
        return Arrays.copyOf(spare.bytes(), spare.length());
    }

    public static String substring(String s, int beginIndex, int endIndex) {
        int realEndIndex;
        if (s == null) {
            return s;
        }
        int n = realEndIndex = s.length() > 0 ? s.length() - 1 : 0;
        if (endIndex > realEndIndex) {
            return s.substring(beginIndex);
        }
        return s.substring(beginIndex, endIndex);
    }

    public static boolean isAllOrWildcard(String[] data) {
        return CollectionUtils.isEmpty(data) || data.length == 1 && Strings.isAllOrWildcard(data[0]);
    }

    public static boolean isAllOrWildcard(String data) {
        return "_all".equals(data) || "*".equals(data);
    }

    public static String toString(MediaType mediaType, ToXContent toXContent) {
        return Strings.toString(mediaType, toXContent, false, false);
    }

    public static String toString(XContentBuilder xContentBuilder) {
        return BytesReference.bytes(xContentBuilder).utf8ToString();
    }

    public static String toString(MediaType mediaType, ToXContent toXContent, ToXContent.Params params) {
        return Strings.toString(mediaType, toXContent, params, false, false);
    }

    public static String toString(MediaType mediaType, ToXContent toXContent, boolean pretty, boolean human) {
        return Strings.toString(mediaType, toXContent, ToXContent.EMPTY_PARAMS, pretty, human);
    }

    private static String toString(MediaType mediaType, ToXContent toXContent, ToXContent.Params params, boolean pretty, boolean human) {
        try {
            XContentBuilder builder = Strings.createBuilder(mediaType, pretty, human);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            return builder.toString();
        }
        catch (IOException e) {
            try {
                XContentBuilder builder = Strings.createBuilder(mediaType, pretty, human);
                builder.startObject();
                builder.field("error", "error building toString out of XContent: " + e.getMessage());
                builder.field("stack_trace", ExceptionsHelper.stackTrace((Throwable)e));
                builder.endObject();
                return builder.toString();
            }
            catch (IOException e2) {
                throw new SkyliteException("cannot generate error message for deserialization", (Throwable)e, new Object[0]);
            }
        }
    }

    private static XContentBuilder createBuilder(MediaType mediaType, boolean pretty, boolean human) throws IOException {
        XContentBuilder builder = XContentBuilder.builder(mediaType.xContent());
        if (pretty) {
            builder.prettyPrint();
        }
        if (human) {
            builder.humanReadable(true);
        }
        return builder;
    }

    public static String cleanTruncate(String s, int length) {
        if (s == null) {
            return s;
        }
        if (length == 0) {
            return EMPTY;
        }
        if (length >= s.length()) {
            return s;
        }
        if (Character.isHighSurrogate(s.charAt(length - 1))) {
            --length;
        }
        return s.substring(0, length);
    }

    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static String requireNonEmpty(String str, String message) {
        if (Strings.isNullOrEmpty(str)) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static String padStart(String s, int minimumLength, char c) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (s.length() >= minimumLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder(minimumLength);
        for (int i = s.length(); i < minimumLength; ++i) {
            sb.append(c);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String toLowercaseAscii(String in) {
        StringBuilder out = new StringBuilder();
        PrimitiveIterator.OfInt iter = in.codePoints().iterator();
        while (iter.hasNext()) {
            int codepoint = (Integer)iter.next();
            if (codepoint > 128) {
                out.appendCodePoint(codepoint);
                continue;
            }
            out.appendCodePoint(Character.toLowerCase(codepoint));
        }
        return out.toString();
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = Strings.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getErrorMessage(String errorMessage, String modelId, boolean isHidden) {
        if (isHidden) {
            return errorMessage;
        }
        return errorMessage + " Model ID: " + modelId;
    }

    public static Map<String, String> parseParameters(Map<String, String> parameters) {
        List<String> toStringParametersPrefixes;
        if (parameters != null && !(toStringParametersPrefixes = Strings.collectToStringPrefixes(parameters)).isEmpty()) {
            for (String prefix : toStringParametersPrefixes) {
                String value = parameters.get(prefix);
                if (value == null) continue;
                parameters.put(prefix + TO_STRING_FUNCTION_NAME, Strings.processTextDoc(value));
            }
        }
        return parameters;
    }

    public static List<String> collectToStringPrefixes(Map<String, String> map) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String key : map.keySet()) {
            String value = map.get(key);
            if (value == null) continue;
            Pattern pattern = Pattern.compile("\\$\\{parameters\\.(.+?)\\.toString\\(\\)\\}");
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String prefix = matcher.group(1);
                prefixes.add(prefix);
            }
        }
        return prefixes;
    }

    public static String processTextDoc(String doc) {
        if (doc != null) {
            String jsonString = Strings.toJson(doc);
            return jsonString.substring(1, jsonString.length() - 1);
        }
        return null;
    }

    public static List<String> processTextDocs(List<String> inputDocs) {
        ArrayList<String> docs = new ArrayList<String>();
        for (String doc : inputDocs) {
            docs.add(Strings.processTextDoc(doc));
        }
        return docs;
    }

    public static String addDefaultMethod(String functionScript) {
        if (!Strings.containsEscapeMethod(functionScript) && Strings.isEscapeUsed(functionScript)) {
            return DEFAULT_ESCAPE_FUNCTION + functionScript;
        }
        return functionScript;
    }

    public static boolean containsEscapeMethod(String input) {
        return Strings.patternExist(input, "String\\s+escape\\s*\\(\\s*(def|String)\\s+.*?\\)\\s*\\{?");
    }

    public static boolean patternExist(String input, String pattern) {
        Pattern p = Pattern.compile(pattern);
        Matcher matcher = p.matcher(input);
        return matcher.find();
    }

    public static boolean isEscapeUsed(String input) {
        return Strings.patternExist(input, "(?<!\\bString\\s+)\\bescape\\s*\\(");
    }

    public static Map<String, String> getParameterMap(Map<String, ?> parameterObjs) {
        HashMap<String, String> parameters = new HashMap<String, String>(parameterObjs.size());
        Iterator<Map.Entry<String, ?>> iterator = parameterObjs.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, ?> entry;
            parameters.put(entry.getKey(), (value = (entry = iterator.next()).getValue()) != null ? value.toString() : "null");
        }
        return parameters;
    }

    public static Map<String, String> getJsonParameterMap(Map<String, ?> parameterObjs) {
        HashMap<String, String> parameters = new HashMap<String, String>(parameterObjs.size());
        for (Map.Entry<String, ?> entry : parameterObjs.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                parameters.put(key, (String)value);
                continue;
            }
            parameters.put(key, Strings.toJson(value));
        }
        return parameters;
    }

    public static Map<String, String> filteredParameterMap(Map<String, ?> parameterObjs, Set<String> allowedList) {
        HashMap<String, String> parameters = new HashMap<String, String>(Math.min(parameterObjs.size(), allowedList.size()));
        for (String key : allowedList) {
            Object value = parameterObjs.get(key);
            if (value == null) continue;
            String stringValue = value.toString();
            if (Strings.isJson(stringValue)) {
                parameters.put(key, stringValue);
                continue;
            }
            if (value instanceof String) {
                parameters.put(key, stringValue);
                continue;
            }
            parameters.put(key, "\"" + stringValue + "\"");
        }
        return parameters;
    }

    public static Map<String, Object> readLargeJsonFile(Path filePath) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (JsonParser parser = OBJECT_MAPPER.getFactory().createParser((Reader)Files.newBufferedReader(filePath));){
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("Invalid JSON format \u2014 expected START_OBJECT");
            }
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String key = parser.getCurrentName();
                parser.nextToken();
                Object value = parser.readValueAs(Object.class);
                result.put(key, value);
            }
        }
        return result;
    }

    public static List<Object> readLargeJsonListFile(Path filePath) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        try (JsonParser parser = OBJECT_MAPPER.getFactory().createParser((Reader)Files.newBufferedReader(filePath));){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                throw new IOException("Invalid JSON format: expected array");
            }
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                result.add(parser.readValueAs(Object.class));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJson(String str) {
        if (str == null) return false;
        if (str.isBlank()) {
            return false;
        }
        try (JsonParser parser = new JsonFactory().disable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES).disable(JsonParser.Feature.ALLOW_TRAILING_COMMA).createParser((Reader)new StringReader(str));){
            JsonToken firstToken = parser.nextToken();
            if (firstToken != JsonToken.START_OBJECT && firstToken != JsonToken.START_ARRAY) {
                boolean bl2 = false;
                return bl2;
            }
            while (parser.nextToken() != null) {
            }
            boolean bl = parser.nextToken() == null;
            return bl;
        }
        catch (JsonParseException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String toJson(Object value) {
        return Strings.toJson(value, false);
    }

    public static String toJson(Object obj, boolean quoteDelimited) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (quoteDelimited) {
                return "\"" + Strings.escapeJson(str) + "\"";
            }
            return str;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return "\"" + Strings.escapeJson(obj.toString()) + "\"";
        }
    }

    public static String escapeJson(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private static String mapToJson(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            sb.append(Strings.toJson(entry.getKey())).append(":").append(Strings.toJson(entry.getValue()));
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String collectionToJson(Collection<?> collection) {
        StringBuilder sb = new StringBuilder("[");
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            sb.append(Strings.toJson(iterator.next()));
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String arrayToJson(Object array) {
        int length = Array.getLength(array);
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < length; ++i) {
            sb.append(Strings.toJson(Array.get(array, i)));
            if (i >= length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static <T> T fromJson(String jsonStr, Class<T> classOfT) {
        if (classOfT == List.class) {
            try {
                List list = (List)OBJECT_MAPPER.readValue(jsonStr, (TypeReference)new TypeReference<List<String>>(){});
                return (T)list;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse JSON into List<String>", e);
            }
        }
        return Strings.fromJson(jsonStr, "default", classOfT);
    }

    public static <T> T fromJson(String jsonStr, String defaultKey, Class<T> classOfT) {
        Map<String, Object> parsedJson = Strings.fromJson(jsonStr, defaultKey);
        if (parsedJson instanceof Map) {
            return Strings.mapToObject(parsedJson, classOfT);
        }
        if (parsedJson instanceof List) {
            throw new IllegalArgumentException("Cannot convert JSON array to object of type " + classOfT.getSimpleName() + ". Use a List<T> instead.");
        }
        throw new IllegalArgumentException("Invalid JSON format for object conversion.");
    }

    public static Map<String, Object> fromJson(String jsonStr, String defaultKey) {
        try {
            JsonNode rootNode = OBJECT_MAPPER.readTree(jsonStr);
            if (rootNode.isArray()) {
                List list = (List)OBJECT_MAPPER.convertValue((Object)rootNode, (TypeReference)new TypeReference<List<Object>>(){});
                HashMap<String, Object> wrappedMap = new HashMap<String, Object>();
                wrappedMap.put(defaultKey, list);
                return wrappedMap;
            }
            if (rootNode.isObject()) {
                return (Map)OBJECT_MAPPER.convertValue((Object)rootNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            throw new IllegalArgumentException("Invalid JSON format");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON format", e);
        }
    }

    public static <T> T fromJson(String jsonStr, TypeReference<T> typeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON using TypeReference", e);
        }
    }

    public static <T> T fromJson(InputStream inputStream, TypeReference<T> typeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(inputStream, typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON from InputStream using TypeReference", e);
        }
    }

    public static <T> T fromJson(Reader reader, TypeReference<T> typeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(reader, typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON from Reader using TypeReference", e);
        }
    }

    public static List<String> fromJsonStringList(String jsonStr) {
        try {
            return (List)OBJECT_MAPPER.readValue(jsonStr, (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON string as List<String>", e);
        }
    }

    public static String extractJsonField(String jsonString, String jsonPointer) {
        try {
            JsonNode rootNode = OBJECT_MAPPER.readTree(jsonString);
            JsonNode extractedNode = rootNode.at(jsonPointer);
            return extractedNode.isMissingNode() ? "null" : extractedNode.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting JSON field using pointer: " + jsonPointer, e);
        }
    }

    public static Object extractJsonObjectField(String jsonString, String jsonPointer) {
        try {
            JsonNode rootNode = OBJECT_MAPPER.readTree(jsonString);
            JsonNode extractedNode = rootNode.at(jsonPointer);
            if (extractedNode.isMissingNode()) {
                return null;
            }
            return OBJECT_MAPPER.treeToValue((TreeNode)extractedNode, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting JSON field using pointer: " + jsonPointer, e);
        }
    }

    private static void assignToStack(Deque<Object> stack, String key, Object value) {
        Object current = stack.peek();
        if (current instanceof Map && key != null) {
            ((Map)current).put(key, value);
        } else if (current instanceof List) {
            ((List)current).add(value);
        }
    }

    private static Object parseJsonValue(String value) {
        if (value.isEmpty()) {
            return null;
        }
        char firstChar = value.charAt(0);
        char lastChar = value.charAt(value.length() - 1);
        if (firstChar == '\"' && lastChar == '\"') {
            return value.substring(1, value.length() - 1);
        }
        if ("null".equals(value)) {
            return null;
        }
        if ("true".equals(value) || "false".equals(value)) {
            return Boolean.parseBoolean(value);
        }
        try {
            if (value.contains(".")) {
                double doubleValue = Double.parseDouble(value);
                return doubleValue == Math.rint(doubleValue) ? (double)((int)doubleValue) : doubleValue;
            }
            long longValue = Long.parseLong(value);
            return longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE ? (long)((int)longValue) : longValue;
        }
        catch (NumberFormatException ignored) {
            return value;
        }
    }

    private static <T> T mapToObject(Map<String, Object> map, Class<T> classOfT) {
        try {
            return (T)OBJECT_MAPPER.convertValue(map, classOfT);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert JSON to object", e);
        }
    }

    private static Object convertType(Object value, Class<?> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return ((Number)value).intValue();
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return ((Number)value).longValue();
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return ((Number)value).doubleValue();
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return value instanceof Boolean && (Boolean)value != false;
        }
        if (targetType == String.class) {
            return value.toString();
        }
        return value;
    }

    public static String hashString(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error: Unable to compute hash", e);
        }
    }

    public static String obtainFieldNameFromJsonPath(String jsonPath) {
        String[] parts = jsonPath.split("\\.");
        return parts[parts.length - 1];
    }

    public static String getJsonPath(String jsonPathWithSource) {
        int startIndex = jsonPathWithSource.indexOf("$.");
        return startIndex != -1 ? jsonPathWithSource.substring(startIndex) : jsonPathWithSource;
    }

    public static boolean pathExists(Object json, String path) {
        if (json == null) {
            throw new IllegalArgumentException("JSON object cannot be null");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path cannot be null or empty");
        }
        if (!Strings.isValidSimpleJsonPath(path)) {
            throw new IllegalArgumentException("The field path is not a valid simple JSON path: " + path);
        }
        try {
            Object cleanedPath;
            JsonNode root = json instanceof String ? OBJECT_MAPPER.readTree((String)json) : OBJECT_MAPPER.valueToTree(json);
            Object object = path.startsWith("$.") ? path.substring(2) : (cleanedPath = path.startsWith("$") ? path.substring(1) : path);
            if (((String)cleanedPath).startsWith("[")) {
                ObjectNode wrapper = OBJECT_MAPPER.createObjectNode();
                wrapper.set("wrapped", root);
                root = wrapper;
                cleanedPath = "wrapped" + (String)cleanedPath;
            }
            String[] parts = ((String)cleanedPath).split("\\.");
            JsonNode current = root;
            for (String part : parts) {
                while (part.matches("^\\[\\d+\\].*")) {
                    int index = Integer.parseInt(part.replaceFirst("^\\[(\\d+)\\].*", "$1"));
                    if (!current.isArray() || index >= current.size()) {
                        return false;
                    }
                    current = current.get(index);
                    part = part.replaceFirst("^\\[\\d+\\]\\.?", EMPTY);
                }
                if (part.isEmpty()) continue;
                if (part.matches(".*\\[\\d+\\]")) {
                    String fieldName = part.substring(0, part.indexOf(91));
                    int index = Integer.parseInt(part.replaceAll(".*\\[(\\d+)\\]", "$1"));
                    if (!(current = current.path(fieldName)).isArray() || index >= current.size()) {
                        return false;
                    }
                    current = current.get(index);
                } else {
                    current = current.path(part);
                }
                if (!current.isMissingNode()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidJSONPath(String input) {
        return Strings.isValidSimpleJsonPath(input);
    }

    private static boolean isValidSimpleJsonPath(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        return path.matches("^\\$?(\\.?[a-zA-Z_\\*][\\w\\*-]*|\\[[0-9]+\\])+$");
    }

    public static Object readJsonPathField(Object json, String path) {
        if (!Strings.isValidSimpleJsonPath(path)) {
            throw new IllegalArgumentException("Invalid JSONPath: " + path);
        }
        try {
            JsonNode root = json instanceof String ? OBJECT_MAPPER.readTree((String)json) : OBJECT_MAPPER.valueToTree(json);
            return Strings.extractFromJsonPath(root, path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse JSON for path: " + path, e);
        }
    }

    public static JsonNode toJsonNode(Object json) {
        try {
            JsonNode jsonNode;
            if (json instanceof String) {
                String str = (String)json;
                jsonNode = OBJECT_MAPPER.readTree(str);
            } else {
                jsonNode = OBJECT_MAPPER.valueToTree(json);
            }
            return jsonNode;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON input", e);
        }
    }

    public static void collectMatchingDotPaths(JsonNode node, String[] pathParts, int index, String currentPath, List<String> results) {
        if (index >= pathParts.length) {
            results.add(currentPath);
            return;
        }
        String part = pathParts[index];
        if ("*".equals(part)) {
            if (node != null) {
                if (node.isArray()) {
                    for (int i = 0; i < node.size(); ++i) {
                        Strings.collectMatchingDotPaths(node.get(i), pathParts, index + 1, currentPath + "[" + i + "]", results);
                    }
                } else if (node.isObject()) {
                    Iterator fields = node.fields();
                    while (fields.hasNext()) {
                        Map.Entry field = (Map.Entry)fields.next();
                        Strings.collectMatchingDotPaths((JsonNode)field.getValue(), pathParts, index + 1, currentPath + "['" + (String)field.getKey() + "']", results);
                    }
                }
            }
        } else {
            String nextPath = currentPath + "['" + part + "']";
            JsonNode child = node != null ? node.get(part) : null;
            Strings.collectMatchingDotPaths(child, pathParts, index + 1, nextPath, results);
        }
    }

    private static void collectPathsRecursive(JsonNode node, String[] parts, int index, String prefix, String leaf, List<String> result) {
        int arrayIndex;
        if (index >= parts.length || node == null || node.isMissingNode()) {
            return;
        }
        String part = parts[index];
        String baseName = part.replaceAll("\\[\\d+\\]", EMPTY);
        int n = arrayIndex = part.contains("[") ? Integer.parseInt(part.replaceAll(".*\\[(\\d+)\\]", "$1")) : -1;
        if (arrayIndex >= 0) {
            JsonNode arrayNode = node.path(baseName);
            if (arrayNode.isArray() && arrayIndex < arrayNode.size()) {
                JsonNode item = arrayNode.get(arrayIndex);
                String newPrefix = prefix + baseName + "[" + arrayIndex + "].";
                if (index == parts.length - 1) {
                    result.add(newPrefix + leaf);
                } else {
                    Strings.collectPathsRecursive(item, parts, index + 1, newPrefix, leaf, result);
                }
            }
        } else {
            JsonNode child = node.path(part);
            if (child.isArray()) {
                for (int i = 0; i < child.size(); ++i) {
                    JsonNode item = child.get(i);
                    String newPrefix = prefix + part + "[" + i + "].";
                    if (index == parts.length - 1) {
                        result.add(newPrefix + leaf);
                        continue;
                    }
                    Strings.collectPathsRecursive(item, parts, index + 1, newPrefix, leaf, result);
                }
            } else {
                String newPrefix = prefix + part + ".";
                if (index == parts.length - 1) {
                    result.add(newPrefix + leaf);
                } else {
                    Strings.collectPathsRecursive(child, parts, index + 1, newPrefix, leaf, result);
                }
            }
        }
    }

    public static Object extractFromJsonPath(JsonNode root, String rawPath) {
        Object cleanedPath;
        if (rawPath == null) {
            return null;
        }
        String path = Strings.getJsonPath(rawPath);
        Object object = path.startsWith("$.") ? path.substring(2) : (cleanedPath = path.startsWith("$") ? path.substring(1) : path);
        if (((String)cleanedPath).startsWith("[")) {
            ObjectNode wrapper = OBJECT_MAPPER.createObjectNode();
            wrapper.set("wrapped", root);
            root = wrapper;
            cleanedPath = "wrapped" + (String)cleanedPath;
        }
        String[] parts = ((String)cleanedPath).split("\\.");
        List<JsonNode> nodes = List.of(root);
        for (String part : parts) {
            ArrayList<JsonNode> nextNodes = new ArrayList<JsonNode>();
            for (JsonNode node : nodes) {
                if ("*".equals(part)) {
                    if (node.isArray()) {
                        node.forEach(nextNodes::add);
                        continue;
                    }
                    if (!node.isObject()) continue;
                    node.fields().forEachRemaining(e -> nextNodes.add((JsonNode)e.getValue()));
                    continue;
                }
                if (part.matches("^.+\\[\\d+\\]$")) {
                    String fieldName = part.substring(0, part.indexOf(91));
                    int idx = Integer.parseInt(part.substring(part.indexOf(91) + 1, part.indexOf(93)));
                    JsonNode child = node.path(fieldName);
                    if (!child.isArray() || idx >= child.size()) continue;
                    nextNodes.add(child.get(idx));
                    continue;
                }
                JsonNode child = node.path(part);
                if (child.isMissingNode()) continue;
                nextNodes.add(child);
            }
            nodes = nextNodes;
            if (!nodes.isEmpty()) continue;
            return null;
        }
        if (nodes.size() == 1) {
            return Strings.convertJsonNode(nodes.get(0));
        }
        ArrayList<Object> result = new ArrayList<Object>(nodes.size());
        for (JsonNode n : nodes) {
            result.add(Strings.convertJsonNode(n));
        }
        return result;
    }

    private static Object convertJsonNode(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isInt()) {
            return node.intValue();
        }
        if (node.isLong()) {
            return node.longValue();
        }
        if (node.isDouble()) {
            return node.doubleValue();
        }
        if (node.isFloat()) {
            return Float.valueOf(node.floatValue());
        }
        if (node.isBoolean()) {
            return node.booleanValue();
        }
        if (node.isTextual()) {
            return node.textValue();
        }
        if (node.isArray()) {
            return OBJECT_MAPPER.convertValue((Object)node, List.class);
        }
        if (node.isObject()) {
            return OBJECT_MAPPER.convertValue((Object)node, Map.class);
        }
        return node.asText();
    }

    public static List<String> parseStringArrayToList(String jsonArrayString) {
        if (jsonArrayString == null || jsonArrayString.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return Strings.fromJson(jsonArrayString, new TypeReference<List<String>>(){

                public Type getType() {
                    return super.getType();
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to parse JSON array string: {}", (Object)jsonArrayString);
            return Collections.emptyList();
        }
    }

    public static Object prepareNestedStructures(Object jsonObject, String fieldPath) {
        if (fieldPath == null) {
            throw new IllegalArgumentException("The field path is null");
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("The object is null");
        }
        if (!Strings.isValidJSONPath(fieldPath)) {
            throw new IllegalArgumentException("The field path is not a valid JSON path: " + fieldPath);
        }
        String path = fieldPath.startsWith("$.") ? fieldPath.substring(2) : fieldPath;
        String[] pathParts = path.split("(?<!\\\\)\\.");
        Map current = jsonObject instanceof Map ? (Map)jsonObject : new HashMap();
        for (String part : pathParts) {
            if (part.contains("[")) {
                String[] arrayParts = part.split("\\[");
                String key = arrayParts[0];
                int index = Integer.parseInt(arrayParts[1].replaceAll("\\]", EMPTY));
                if (!current.containsKey(key)) {
                    current.put(key, new ArrayList());
                }
                if (!(current.get(key) instanceof List)) {
                    return jsonObject;
                }
                List list = (List)current.get(key);
                if (index >= list.size()) {
                    while (list.size() <= index) {
                        list.add(null);
                    }
                    list.set(index, new HashMap());
                }
                if (!(list.get(index) instanceof Map)) {
                    return jsonObject;
                }
                current = (Map)list.get(index);
                continue;
            }
            if (!current.containsKey(part)) {
                current.put(part, new HashMap());
            } else if (!(current.get(part) instanceof Map)) {
                return jsonObject;
            }
            current = (Map)current.get(part);
        }
        return jsonObject;
    }

    public static void setJsonPathValue(Object json, String rawPath, Object value) {
        if (json == null || rawPath == null) {
            return;
        }
        String path = Strings.getJsonPath(rawPath);
        String[] parts = path.startsWith("$.") ? path.substring(2).split("\\.") : path.split("\\.");
        Map current = (Map)json;
        for (int i = 0; i < parts.length; ++i) {
            boolean isLast;
            String part = parts[i];
            boolean bl = isLast = i == parts.length - 1;
            if (part.matches(".*\\[\\d+\\]")) {
                String key = part.substring(0, part.indexOf(91));
                int index = Integer.parseInt(part.replaceAll(".*\\[(\\d+)\\]", "$1"));
                List list = (List)current.computeIfAbsent(key, k -> new ArrayList());
                while (list.size() <= index) {
                    list.add(null);
                }
                if (isLast) {
                    list.set(index, value);
                    continue;
                }
                Object next = list.get(index);
                if (!(next instanceof Map)) {
                    next = new HashMap();
                    list.set(index, next);
                }
                current = (Map)next;
                continue;
            }
            if (isLast) {
                current.put(part, value);
                continue;
            }
            Object next = current.get(part);
            if (!(next instanceof Map)) {
                next = new HashMap();
                current.put(part, next);
            }
            current = (Map)next;
        }
    }

    public static String getStackTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class JsonFieldMissingException
    extends RuntimeException {
        public JsonFieldMissingException(String message) {
            super(message);
        }
    }
}

