/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.breaker;

import io.skylite.core.common.breaker.CircuitBreakingException;
import java.util.Locale;

public interface CircuitBreaker {
    public static final String PARENT = "parent";
    public static final String FIELDDATA = "fielddata";
    public static final String REQUEST = "request";
    public static final String IN_FLIGHT_REQUESTS = "in_flight_requests";

    public void circuitBreak(String var1, long var2);

    public double addEstimateBytesAndMaybeBreak(long var1, String var3) throws CircuitBreakingException;

    public long addWithoutBreaking(long var1);

    public long getUsed();

    public long getLimit();

    public double getOverhead();

    public long getTrippedCount();

    public String getName();

    public Durability getDurability();

    public void setLimitAndOverhead(long var1, double var3);

    public static enum Durability {
        TRANSIENT,
        PERMANENT;

    }

    public static enum Type {
        MEMORY,
        PARENT,
        NOOP;


        public static Type parseValue(String value) {
            switch (value.toLowerCase(Locale.ROOT)) {
                case "noop": {
                    return NOOP;
                }
                case "parent": {
                    return PARENT;
                }
                case "memory": {
                    return MEMORY;
                }
            }
            throw new IllegalArgumentException("No CircuitBreaker with type: " + value);
        }
    }
}

