/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.bytes;

import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.ToIntBiFunction;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.UnicodeUtil;

public abstract class AbstractBytesReference
implements BytesReference {
    private Integer hash = null;
    private static final int MAX_UTF16_LENGTH = 0x3FFFFFFF;

    @Override
    public int getInt(int index) {
        return (this.get(index) & 0xFF) << 24 | (this.get(index + 1) & 0xFF) << 16 | (this.get(index + 2) & 0xFF) << 8 | this.get(index + 3) & 0xFF;
    }

    @Override
    public int indexOf(byte marker, int from) {
        int to = this.length();
        for (int i = from; i < to; ++i) {
            if (this.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    @Override
    public StreamInput streamInput() throws IOException {
        return new BytesReferenceStreamInput();
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        BytesRef ref;
        BytesRefIterator iterator = this.iterator();
        while ((ref = iterator.next()) != null) {
            os.write(ref.bytes, ref.offset, ref.length);
        }
    }

    protected int getMaxUTF16Length() {
        return 0x3FFFFFFF;
    }

    @Override
    public String utf8ToString() {
        char[] ref;
        BytesRef bytesRef = this.toBytesRef();
        int len = UnicodeUtil.UTF8toUTF16((BytesRef)bytesRef, (char[])(ref = new char[bytesRef.length]));
        if (len > this.getMaxUTF16Length()) {
            throw new IllegalArgumentException("UTF16 String size is " + len + ", should be less than " + this.getMaxUTF16Length());
        }
        return new String(ref, 0, len);
    }

    @Override
    public BytesRefIterator iterator() {
        return new BytesRefIterator(){
            BytesRef ref;
            {
                this.ref = AbstractBytesReference.this.length() == 0 ? null : AbstractBytesReference.this.toBytesRef();
            }

            public BytesRef next() {
                BytesRef r = this.ref;
                this.ref = null;
                return r;
            }
        };
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BytesReference) {
            BytesReference otherRef = (BytesReference)other;
            if (this.length() != otherRef.length()) {
                return false;
            }
            return AbstractBytesReference.compareIterators(this, otherRef, (a, b) -> a.bytesEquals(b) ? 0 : 1) == 0;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == null) {
            BytesRefIterator iterator = this.iterator();
            int result = 1;
            try {
                BytesRef ref;
                while ((ref = iterator.next()) != null) {
                    for (int i = 0; i < ref.length; ++i) {
                        result = 31 * result + ref.bytes[ref.offset + i];
                    }
                }
            }
            catch (IOException ex) {
                throw new AssertionError("wont happen", ex);
            }
            this.hash = result;
            return this.hash;
        }
        return this.hash;
    }

    @Override
    public int compareTo(BytesReference other) {
        return AbstractBytesReference.compareIterators(this, other, BytesRef::compareTo);
    }

    private static int compareIterators(BytesReference a, BytesReference b, ToIntBiFunction<BytesRef, BytesRef> f) {
        try {
            long lengthToCompare = Math.min(a.length(), b.length());
            BytesRefIterator aIter = a.iterator();
            BytesRefIterator bIter = b.iterator();
            BytesRef aRef = aIter.next();
            BytesRef bRef = bIter.next();
            if (aRef != null && bRef != null) {
                aRef = aRef.clone();
                bRef = bRef.clone();
                if (aRef.length == a.length() && bRef.length == b.length()) {
                    return f.applyAsInt(aRef, bRef);
                }
                int i = 0;
                while ((long)i < lengthToCompare) {
                    int length;
                    if (aRef.length == 0) {
                        aRef = aIter.next().clone();
                    }
                    if (bRef.length == 0) {
                        bRef = bIter.next().clone();
                    }
                    int aLength = aRef.length;
                    int bLength = bRef.length;
                    aRef.length = bRef.length = (length = Math.min(aLength, bLength));
                    int diff = f.applyAsInt(aRef, bRef);
                    aRef.length = aLength;
                    bRef.length = bLength;
                    if (diff != 0) {
                        return diff;
                    }
                    AbstractBytesReference.advance(aRef, length);
                    AbstractBytesReference.advance(bRef, length);
                    i += length;
                }
            }
            return a.length() - b.length();
        }
        catch (IOException ex) {
            throw new AssertionError("can not happen", ex);
        }
    }

    private static void advance(BytesRef ref, int length) {
        assert (ref.length >= length) : " ref.length: " + ref.length + " length: " + length;
        assert (ref.offset + length < ref.bytes.length || ref.offset + length == ref.bytes.length && ref.length - length == 0) : "offset: " + ref.offset + " ref.bytes.length: " + ref.bytes.length + " length: " + length + " ref.length: " + ref.length;
        ref.length -= length;
        ref.offset += length;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        BytesRef bytes = this.toBytesRef();
        return builder.value(bytes.bytes, bytes.offset, bytes.length);
    }

    private final class BytesReferenceStreamInput
    extends StreamInput {
        private BytesRefIterator iterator;
        private int sliceIndex;
        private BytesRef slice;
        private int sliceStartOffset;
        private int mark = 0;

        BytesReferenceStreamInput() throws IOException {
            this.iterator = AbstractBytesReference.this.iterator();
            this.slice = this.iterator.next();
            this.sliceStartOffset = 0;
            this.sliceIndex = 0;
        }

        @Override
        public byte readByte() throws IOException {
            if (this.offset() >= AbstractBytesReference.this.length()) {
                throw new EOFException();
            }
            this.maybeNextSlice();
            return this.slice.bytes[this.slice.offset + this.sliceIndex++];
        }

        private int offset() {
            return this.sliceStartOffset + this.sliceIndex;
        }

        private void maybeNextSlice() throws IOException {
            while (this.sliceIndex == this.slice.length) {
                this.sliceStartOffset += this.sliceIndex;
                this.slice = this.iterator.next();
                this.sliceIndex = 0;
                if (this.slice != null) continue;
                throw new EOFException();
            }
        }

        @Override
        public void readBytes(byte[] b, int bOffset, int len) throws IOException {
            int length = AbstractBytesReference.this.length();
            int offset = this.offset();
            if (offset + len > length) {
                throw new IndexOutOfBoundsException("Cannot read " + len + " bytes from stream with length " + length + " at offset " + offset);
            }
            int bytesRead = this.read(b, bOffset, len);
            assert (bytesRead == len) : bytesRead + " vs " + len;
        }

        @Override
        public int read() throws IOException {
            if (this.offset() >= AbstractBytesReference.this.length()) {
                return -1;
            }
            return Byte.toUnsignedInt(this.readByte());
        }

        @Override
        public int read(byte[] b, int bOffset, int len) throws IOException {
            int numBytesToCopy;
            int length = AbstractBytesReference.this.length();
            int offset = this.offset();
            if (offset >= length) {
                return -1;
            }
            int remaining = numBytesToCopy = Math.min(len, length - offset);
            int destOffset = bOffset;
            while (remaining > 0) {
                this.maybeNextSlice();
                int currentLen = Math.min(remaining, this.slice.length - this.sliceIndex);
                assert (currentLen > 0) : "length has to be > 0 to make progress but was: " + currentLen;
                System.arraycopy(this.slice.bytes, this.slice.offset + this.sliceIndex, b, destOffset, currentLen);
                destOffset += currentLen;
                this.sliceIndex += currentLen;
                assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
            }
            return numBytesToCopy;
        }

        @Override
        public void close() {
        }

        @Override
        public int available() {
            return AbstractBytesReference.this.length() - this.offset();
        }

        @Override
        protected void ensureCanReadBytes(int bytesToRead) throws EOFException {
            int bytesAvailable = AbstractBytesReference.this.length() - this.offset();
            if (bytesAvailable < bytesToRead) {
                throw new EOFException("tried to read: " + bytesToRead + " bytes but only " + bytesAvailable + " remaining");
            }
        }

        @Override
        public long skip(long n) throws IOException {
            int numBytesSkipped;
            if (n <= 0L) {
                return 0L;
            }
            assert (this.offset() <= AbstractBytesReference.this.length()) : this.offset() + " vs " + AbstractBytesReference.this.length();
            int remaining = numBytesSkipped = (int)Math.min(n, (long)(AbstractBytesReference.this.length() - this.offset()));
            while (remaining > 0) {
                this.maybeNextSlice();
                int currentLen = Math.min(remaining, this.slice.length - this.sliceIndex);
                this.sliceIndex += currentLen;
                assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
            }
            return numBytesSkipped;
        }

        @Override
        public void reset() throws IOException {
            if (this.sliceStartOffset <= this.mark) {
                this.sliceIndex = this.mark - this.sliceStartOffset;
            } else {
                this.iterator = AbstractBytesReference.this.iterator();
                this.slice = this.iterator.next();
                this.sliceStartOffset = 0;
                this.sliceIndex = 0;
                long skipped = this.skip(this.mark);
                assert (skipped == (long)this.mark) : skipped + " vs " + this.mark;
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readLimit) {
            this.mark = this.offset();
        }
    }
}

