/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.concurrent;

import io.skylite.common.lifecycle.Lifecycle;
import io.skylite.common.util.concurrent.AbstractRunnable;
import java.util.Objects;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLifecycleRunnable
extends AbstractRunnable {
    private final Lifecycle lifecycle;
    private final Logger logger;

    public AbstractLifecycleRunnable(Lifecycle lifecycle, Logger logger) {
        this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle must not be null");
        this.logger = Objects.requireNonNull(logger, "logger must not be null");
    }

    public final void doRun() throws Exception {
        if (this.lifecycle.stoppedOrClosed()) {
            this.logger.trace("lifecycle is stopping. exiting");
            return;
        }
        this.doRunInLifecycle();
    }

    protected abstract void doRunInLifecycle() throws Exception;

    public final void onAfter() {
        if (!this.lifecycle.stoppedOrClosed()) {
            this.onAfterInLifecycle();
        }
    }

    protected void onAfterInLifecycle() {
    }
}

